"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _assertThisInitialized2 = _interopRequireDefault(require("@babel/runtime/helpers/assertThisInitialized"));

var _get2 = _interopRequireDefault(require("@babel/runtime/helpers/get"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _core = require("@luma.gl/core");

var _core2 = require("@deck.gl/core");

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { (0, _defineProperty2.default)(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

var MaskPass = function (_LayersPass) {
  (0, _inherits2.default)(MaskPass, _LayersPass);

  var _super = _createSuper(MaskPass);

  function MaskPass(gl, props) {
    var _parameters;

    var _this;

    (0, _classCallCheck2.default)(this, MaskPass);
    _this = _super.call(this, gl, props);
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "maskMap", void 0);
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "fbo", void 0);
    var _props$mapSize = props.mapSize,
        mapSize = _props$mapSize === void 0 ? 2048 : _props$mapSize;
    _this.maskMap = new _core.Texture2D(gl, {
      width: mapSize,
      height: mapSize,
      parameters: (_parameters = {}, (0, _defineProperty2.default)(_parameters, 10241, 9729), (0, _defineProperty2.default)(_parameters, 10240, 9729), (0, _defineProperty2.default)(_parameters, 10242, 33071), (0, _defineProperty2.default)(_parameters, 10243, 33071), _parameters)
    });
    _this.fbo = new _core.Framebuffer(gl, {
      id: 'maskmap',
      width: mapSize,
      height: mapSize,
      attachments: (0, _defineProperty2.default)({}, 36064, _this.maskMap)
    });
    return _this;
  }

  (0, _createClass2.default)(MaskPass, [{
    key: "render",
    value: function render(options) {
      var _this2 = this;

      var gl = this.gl;
      var colorMask = [false, false, false, false];
      colorMask[options.channel] = true;
      return (0, _core.withParameters)(gl, {
        clearColor: [255, 255, 255, 255],
        blend: true,
        blendFunc: [0, 1],
        blendEquation: 32778,
        colorMask: colorMask,
        depthTest: false
      }, function () {
        return (0, _get2.default)((0, _getPrototypeOf2.default)(MaskPass.prototype), "render", _this2).call(_this2, _objectSpread(_objectSpread({}, options), {}, {
          target: _this2.fbo,
          pass: 'mask'
        }));
      });
    }
  }, {
    key: "shouldDrawLayer",
    value: function shouldDrawLayer(layer) {
      return layer.props.operation.includes('mask');
    }
  }, {
    key: "delete",
    value: function _delete() {
      this.fbo.delete();
      this.maskMap.delete();
    }
  }]);
  return MaskPass;
}(_core2._LayersPass);

exports.default = MaskPass;
//# sourceMappingURL=mask-pass.js.map