"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _core = require("@deck.gl/core");

var _shaders = require("./shaders.glsl");

var _vec = require("gl-matrix/vec3");

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

var defaultProps = {
  getDashArray: {
    type: 'accessor',
    value: [0, 0]
  },
  getOffset: {
    type: 'accessor',
    value: 0
  },
  dashJustified: false,
  dashGapPickable: false
};

var PathStyleExtension = function (_LayerExtension) {
  (0, _inherits2.default)(PathStyleExtension, _LayerExtension);

  var _super = _createSuper(PathStyleExtension);

  function PathStyleExtension() {
    var _ref = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
        _ref$dash = _ref.dash,
        dash = _ref$dash === void 0 ? false : _ref$dash,
        _ref$offset = _ref.offset,
        offset = _ref$offset === void 0 ? false : _ref$offset,
        _ref$highPrecisionDas = _ref.highPrecisionDash,
        highPrecisionDash = _ref$highPrecisionDas === void 0 ? false : _ref$highPrecisionDas;

    (0, _classCallCheck2.default)(this, PathStyleExtension);
    return _super.call(this, {
      dash: dash || highPrecisionDash,
      offset: offset,
      highPrecisionDash: highPrecisionDash
    });
  }

  (0, _createClass2.default)(PathStyleExtension, [{
    key: "isEnabled",
    value: function isEnabled(layer) {
      return 'pathTesselator' in layer.state;
    }
  }, {
    key: "getShaders",
    value: function getShaders(extension) {
      if (!extension.isEnabled(this)) {
        return null;
      }

      var result = {};

      if (extension.opts.dash) {
        result = (0, _core._mergeShaders)(result, _shaders.dashShaders);
      }

      if (extension.opts.offset) {
        result = (0, _core._mergeShaders)(result, _shaders.offsetShaders);
      }

      return result;
    }
  }, {
    key: "initializeState",
    value: function initializeState(context, extension) {
      var attributeManager = this.getAttributeManager();

      if (!attributeManager || !extension.isEnabled(this)) {
        return;
      }

      if (extension.opts.dash) {
        attributeManager.addInstanced({
          instanceDashArrays: {
            size: 2,
            accessor: 'getDashArray'
          }
        });
      }

      if (extension.opts.highPrecisionDash) {
        attributeManager.addInstanced({
          instanceDashOffsets: {
            size: 1,
            accessor: 'getPath',
            transform: extension.getDashOffsets.bind(this)
          }
        });
      }

      if (extension.opts.offset) {
        attributeManager.addInstanced({
          instanceOffsets: {
            size: 1,
            accessor: 'getOffset'
          }
        });
      }
    }
  }, {
    key: "updateState",
    value: function updateState(params, extension) {
      if (!extension.isEnabled(this)) {
        return;
      }

      var uniforms = {};

      if (extension.opts.dash) {
        uniforms.dashAlignMode = this.props.dashJustified ? 1 : 0;
        uniforms.dashGapPickable = Boolean(this.props.dashGapPickable);
      }

      this.state.model.setUniforms(uniforms);
    }
  }, {
    key: "getDashOffsets",
    value: function getDashOffsets(path) {
      var result = [0];
      var positionSize = this.props.positionFormat === 'XY' ? 2 : 3;
      var isNested = Array.isArray(path[0]);
      var geometrySize = isNested ? path.length : path.length / positionSize;
      var p;
      var prevP;

      for (var i = 0; i < geometrySize - 1; i++) {
        p = isNested ? path[i] : path.slice(i * positionSize, i * positionSize + positionSize);
        p = this.projectPosition(p);

        if (i > 0) {
          result[i] = result[i - 1] + (0, _vec.dist)(prevP, p);
        }

        prevP = p;
      }

      return result;
    }
  }]);
  return PathStyleExtension;
}(_core.LayerExtension);

exports.default = PathStyleExtension;
(0, _defineProperty2.default)(PathStyleExtension, "defaultProps", defaultProps);
(0, _defineProperty2.default)(PathStyleExtension, "extensionName", 'PathStyleExtension');
//# sourceMappingURL=path-style-extension.js.map