"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HeightMapBuilder = void 0;

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _core = require("@luma.gl/core");

var _projectionUtils = require("../utils/projection-utils");

var _utils = require("./utils");

var MAP_MAX_SIZE = 2048;

var HeightMapBuilder = function () {
  function HeightMapBuilder(gl) {
    (0, _classCallCheck2.default)(this, HeightMapBuilder);
    (0, _defineProperty2.default)(this, "renderViewport", null);
    (0, _defineProperty2.default)(this, "bounds", null);
    (0, _defineProperty2.default)(this, "fbo", void 0);
    (0, _defineProperty2.default)(this, "gl", void 0);
    (0, _defineProperty2.default)(this, "layers", []);
    (0, _defineProperty2.default)(this, "layersBounds", []);
    (0, _defineProperty2.default)(this, "layersBoundsCommon", null);
    (0, _defineProperty2.default)(this, "lastViewport", null);
    this.gl = gl;
  }

  (0, _createClass2.default)(HeightMapBuilder, [{
    key: "getRenderFramebuffer",
    value: function getRenderFramebuffer() {
      if (!this.renderViewport) {
        return null;
      }

      if (!this.fbo) {
        this.fbo = (0, _utils.createRenderTarget)(this.gl, {
          id: 'height-map',
          float: true
        });
      }

      return this.fbo;
    }
  }, {
    key: "shouldUpdate",
    value: function shouldUpdate(_ref) {
      var _this = this;

      var layers = _ref.layers,
          viewport = _ref.viewport;
      var layersChanged = layers.length !== this.layers.length || layers.some(function (layer, i) {
        return layer !== _this.layers[i] || layer.props.transitions || layer.getBounds() !== _this.layersBounds[i];
      });

      if (layersChanged) {
        this.layers = layers;
        this.layersBounds = layers.map(function (layer) {
          return layer.getBounds();
        });
        this.layersBoundsCommon = (0, _projectionUtils.joinLayerBounds)(layers, viewport);
      }

      var viewportChanged = !this.lastViewport || !viewport.equals(this.lastViewport);

      if (!this.layersBoundsCommon) {
        this.renderViewport = null;
      } else if (layersChanged || viewportChanged) {
        var bounds = (0, _projectionUtils.getRenderBounds)(this.layersBoundsCommon, viewport);

        if (bounds[2] <= bounds[0] || bounds[3] <= bounds[1]) {
          this.renderViewport = null;
          return false;
        }

        this.bounds = bounds;
        this.lastViewport = viewport;
        var scale = viewport.scale;
        var pixelWidth = (bounds[2] - bounds[0]) * scale;
        var pixelHeight = (bounds[3] - bounds[1]) * scale;
        this.renderViewport = pixelWidth > 0 || pixelHeight > 0 ? (0, _projectionUtils.makeViewport)({
          bounds: [viewport.center[0] - 1, viewport.center[1] - 1, viewport.center[0] + 1, viewport.center[1] + 1],
          zoom: viewport.zoom,
          width: Math.min(pixelWidth, MAP_MAX_SIZE),
          height: Math.min(pixelHeight, MAP_MAX_SIZE),
          viewport: viewport
        }) : null;
        return true;
      }

      return false;
    }
  }, {
    key: "delete",
    value: function _delete() {
      if (this.fbo) {
        this.fbo.color.delete();
        this.fbo.delete();
      }
    }
  }], [{
    key: "isSupported",
    value: function isSupported(gl) {
      return _core.Framebuffer.isSupported(gl, {
        colorBufferFloat: true
      });
    }
  }]);
  return HeightMapBuilder;
}();

exports.HeightMapBuilder = HeightMapBuilder;
//# sourceMappingURL=height-map-builder.js.map