"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TerrainCover = void 0;

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _utils = require("./utils");

var _projectionUtils = require("../utils/projection-utils");

function _createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it.return != null) it.return(); } finally { if (didErr) throw err; } } }; }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

var TerrainCover = function () {
  function TerrainCover(targetLayer) {
    (0, _classCallCheck2.default)(this, TerrainCover);
    (0, _defineProperty2.default)(this, "isDirty", true);
    (0, _defineProperty2.default)(this, "targetLayer", void 0);
    (0, _defineProperty2.default)(this, "renderViewport", null);
    (0, _defineProperty2.default)(this, "bounds", null);
    (0, _defineProperty2.default)(this, "fbo", void 0);
    (0, _defineProperty2.default)(this, "pickingFbo", void 0);
    (0, _defineProperty2.default)(this, "layers", []);
    (0, _defineProperty2.default)(this, "tile", void 0);
    (0, _defineProperty2.default)(this, "targetBounds", null);
    (0, _defineProperty2.default)(this, "targetBoundsCommon", null);
    this.targetLayer = targetLayer;
    this.tile = getTile(targetLayer);
  }

  (0, _createClass2.default)(TerrainCover, [{
    key: "id",
    get: function get() {
      return this.targetLayer.id;
    }
  }, {
    key: "isActive",
    get: function get() {
      return Boolean(this.targetLayer.getCurrentLayer());
    }
  }, {
    key: "shouldUpdate",
    value: function shouldUpdate(_ref) {
      var targetLayer = _ref.targetLayer,
          viewport = _ref.viewport,
          layers = _ref.layers,
          layerNeedsRedraw = _ref.layerNeedsRedraw;

      if (targetLayer) {
        this.targetLayer = targetLayer;
      }

      var sizeChanged = viewport ? this._updateViewport(viewport) : false;
      var layersChanged = layers ? this._updateLayers(layers) : false;

      if (layerNeedsRedraw) {
        var _iterator = _createForOfIteratorHelper(this.layers),
            _step;

        try {
          for (_iterator.s(); !(_step = _iterator.n()).done;) {
            var id = _step.value;

            if (layerNeedsRedraw[id]) {
              layersChanged = true;
              break;
            }
          }
        } catch (err) {
          _iterator.e(err);
        } finally {
          _iterator.f();
        }
      }

      return layersChanged || sizeChanged;
    }
  }, {
    key: "_updateLayers",
    value: function _updateLayers(layers) {
      var needsRedraw = false;
      layers = this.tile ? getIntersectingLayers(this.tile, layers) : layers;

      if (layers.length !== this.layers.length) {
        needsRedraw = true;
      } else {
        for (var i = 0; i < layers.length; i++) {
          var id = layers[i].id;

          if (id !== this.layers[i]) {
            needsRedraw = true;
            break;
          }
        }
      }

      if (needsRedraw) {
        this.layers = layers.map(function (layer) {
          return layer.id;
        });
      }

      return needsRedraw;
    }
  }, {
    key: "_updateViewport",
    value: function _updateViewport(viewport) {
      var targetLayer = this.targetLayer;
      var shouldRedraw = false;

      if (this.tile && 'boundingBox' in this.tile) {
        if (!this.targetBounds) {
          shouldRedraw = true;
          this.targetBounds = this.tile.boundingBox;
          var bottomLeftCommon = viewport.projectPosition(this.targetBounds[0]);
          var topRightCommon = viewport.projectPosition(this.targetBounds[1]);
          this.targetBoundsCommon = [bottomLeftCommon[0], bottomLeftCommon[1], topRightCommon[0], topRightCommon[1]];
        }
      } else if (this.targetBounds !== targetLayer.getBounds()) {
        shouldRedraw = true;
        this.targetBounds = targetLayer.getBounds();
        this.targetBoundsCommon = (0, _projectionUtils.joinLayerBounds)([targetLayer], viewport);
      }

      if (!this.targetBoundsCommon) {
        return false;
      }

      var newZoom = Math.ceil(viewport.zoom + 0.5);

      if (this.tile) {
        this.bounds = this.targetBoundsCommon;
      } else {
        var _this$renderViewport;

        var oldZoom = (_this$renderViewport = this.renderViewport) === null || _this$renderViewport === void 0 ? void 0 : _this$renderViewport.zoom;
        shouldRedraw = shouldRedraw || newZoom !== oldZoom;
        var newBounds = (0, _projectionUtils.getRenderBounds)(this.targetBoundsCommon, viewport);
        var oldBounds = this.bounds;
        shouldRedraw = shouldRedraw || !oldBounds || newBounds.some(function (x, i) {
          return x !== oldBounds[i];
        });
        this.bounds = newBounds;
      }

      if (shouldRedraw) {
        this.renderViewport = (0, _projectionUtils.makeViewport)({
          bounds: this.bounds,
          zoom: newZoom,
          viewport: viewport
        });
      }

      return shouldRedraw;
    }
  }, {
    key: "getRenderFramebuffer",
    value: function getRenderFramebuffer() {
      if (!this.renderViewport || this.layers.length === 0) {
        return null;
      }

      if (!this.fbo) {
        this.fbo = (0, _utils.createRenderTarget)(this.targetLayer.context.gl, {
          id: this.id
        });
      }

      return this.fbo;
    }
  }, {
    key: "getPickingFramebuffer",
    value: function getPickingFramebuffer() {
      if (!this.renderViewport || this.layers.length === 0 && !this.targetLayer.props.pickable) {
        return null;
      }

      if (!this.pickingFbo) {
        this.pickingFbo = (0, _utils.createRenderTarget)(this.targetLayer.context.gl, {
          id: "".concat(this.id, "-picking")
        });
      }

      return this.pickingFbo;
    }
  }, {
    key: "filterLayers",
    value: function filterLayers(layers) {
      var _this = this;

      return layers.filter(function (_ref2) {
        var id = _ref2.id;
        return _this.layers.includes(id);
      });
    }
  }, {
    key: "delete",
    value: function _delete() {
      var fbo = this.fbo,
          pickingFbo = this.pickingFbo;

      if (fbo) {
        fbo.texture.delete();
        fbo.delete();
      }

      if (pickingFbo) {
        pickingFbo.texture.delete();
        pickingFbo.delete();
      }
    }
  }]);
  return TerrainCover;
}();

exports.TerrainCover = TerrainCover;

function getIntersectingLayers(sourceTile, layers) {
  return layers.filter(function (layer) {
    var tile = getTile(layer);

    if (tile) {
      return intersect(sourceTile.boundingBox, tile.boundingBox);
    }

    return true;
  });
}

function getTile(layer) {
  while (layer) {
    var tile = layer.props.tile;

    if (tile) {
      return tile;
    }

    layer = layer.parent;
  }

  return null;
}

function intersect(b1, b2) {
  if (b1 && b2) {
    return b1[0][0] < b2[1][0] && b2[0][0] < b1[1][0] && b1[0][1] < b2[1][1] && b2[0][1] < b1[1][1];
  }

  return false;
}
//# sourceMappingURL=terrain-cover.js.map