"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TerrainEffect = void 0;

var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _core = require("@luma.gl/core");

var _core2 = require("@deck.gl/core");

var _shaderModule = require("./shader-module");

var _terrainCover = require("./terrain-cover");

var _terrainPass = require("./terrain-pass");

var _terrainPickingPass = require("./terrain-picking-pass");

var _heightMapBuilder = require("./height-map-builder");

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { (0, _defineProperty2.default)(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it.return != null) it.return(); } finally { if (didErr) throw err; } } }; }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

var TerrainEffect = function () {
  function TerrainEffect() {
    (0, _classCallCheck2.default)(this, TerrainEffect);
    (0, _defineProperty2.default)(this, "id", 'terrain-effect');
    (0, _defineProperty2.default)(this, "props", null);
    (0, _defineProperty2.default)(this, "useInPicking", true);
    (0, _defineProperty2.default)(this, "isPicking", false);
    (0, _defineProperty2.default)(this, "isDrapingEnabled", false);
    (0, _defineProperty2.default)(this, "dummyHeightMap", void 0);
    (0, _defineProperty2.default)(this, "heightMap", void 0);
    (0, _defineProperty2.default)(this, "terrainPass", void 0);
    (0, _defineProperty2.default)(this, "terrainPickingPass", void 0);
    (0, _defineProperty2.default)(this, "terrainCovers", new Map());
  }

  (0, _createClass2.default)(TerrainEffect, [{
    key: "initialize",
    value: function initialize(gl) {
      this.dummyHeightMap = new _core.Texture2D(gl, {
        width: 1,
        height: 1,
        data: new Uint8Array([0, 0, 0, 0])
      });
      this.terrainPass = new _terrainPass.TerrainPass(gl, {
        id: 'terrain'
      });
      this.terrainPickingPass = new _terrainPickingPass.TerrainPickingPass(gl, {
        id: 'terrain-picking'
      });

      if (_heightMapBuilder.HeightMapBuilder.isSupported(gl)) {
        this.heightMap = new _heightMapBuilder.HeightMapBuilder(gl);
      } else {
        _core2.log.warn('Terrain offset mode is not supported by this browser')();
      }

      _core.ProgramManager.getDefaultProgramManager(gl).addDefaultModule(_shaderModule.terrainModule);
    }
  }, {
    key: "preRender",
    value: function preRender(gl, opts) {
      if (!this.dummyHeightMap) {
        this.initialize(gl);

        var _iterator = _createForOfIteratorHelper(opts.layers),
            _step;

        try {
          for (_iterator.s(); !(_step = _iterator.n()).done;) {
            var layer = _step.value;

            if (layer.props.operation.includes('terrain')) {
              layer.setChangeFlags({
                extensionsChanged: true
              });
            }
          }
        } catch (err) {
          _iterator.e(err);
        } finally {
          _iterator.f();
        }
      }

      if (opts.pickZ) {
        this.isDrapingEnabled = false;
        return;
      }

      var viewports = opts.viewports;
      var isPicking = opts.pass.startsWith('picking');
      this.isPicking = isPicking;
      this.isDrapingEnabled = true;
      var viewport = viewports[0];
      var layers = (isPicking ? this.terrainPickingPass : this.terrainPass).getRenderableLayers(viewport, opts);
      var terrainLayers = layers.filter(function (l) {
        return l.props.operation.includes('terrain');
      });

      if (terrainLayers.length === 0) {
        return;
      }

      if (!isPicking) {
        var offsetLayers = layers.filter(function (l) {
          return l.state.terrainDrawMode === 'offset';
        });

        if (offsetLayers.length > 0) {
          this._updateHeightMap(terrainLayers, viewport, opts);
        }
      }

      var drapeLayers = layers.filter(function (l) {
        return l.state.terrainDrawMode === 'drape';
      });

      this._updateTerrainCovers(terrainLayers, drapeLayers, viewport, opts);
    }
  }, {
    key: "getModuleParameters",
    value: function getModuleParameters(layer) {
      var _this$heightMap, _this$heightMap2;

      var terrainDrawMode = layer.state.terrainDrawMode;
      return {
        heightMap: (_this$heightMap = this.heightMap) === null || _this$heightMap === void 0 ? void 0 : _this$heightMap.getRenderFramebuffer(),
        heightMapBounds: (_this$heightMap2 = this.heightMap) === null || _this$heightMap2 === void 0 ? void 0 : _this$heightMap2.bounds,
        dummyHeightMap: this.dummyHeightMap,
        terrainCover: this.isDrapingEnabled ? this.terrainCovers.get(layer.id) : null,
        useTerrainHeightMap: terrainDrawMode === 'offset',
        terrainSkipRender: terrainDrawMode === 'drape' || !layer.props.operation.includes('draw')
      };
    }
  }, {
    key: "cleanup",
    value: function cleanup() {
      if (this.dummyHeightMap) {
        this.dummyHeightMap.delete();
        this.dummyHeightMap = undefined;
      }

      if (this.heightMap) {
        this.heightMap.delete();
        this.heightMap = undefined;
      }

      var _iterator2 = _createForOfIteratorHelper(this.terrainCovers.values()),
          _step2;

      try {
        for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
          var terrainCover = _step2.value;
          terrainCover.delete();
        }
      } catch (err) {
        _iterator2.e(err);
      } finally {
        _iterator2.f();
      }

      this.terrainCovers.clear();
    }
  }, {
    key: "_updateHeightMap",
    value: function _updateHeightMap(terrainLayers, viewport, opts) {
      if (!this.heightMap) {
        return;
      }

      var shouldUpdate = this.heightMap.shouldUpdate({
        layers: terrainLayers,
        viewport: viewport
      });

      if (!shouldUpdate) {
        return;
      }

      this.terrainPass.renderHeightMap(this.heightMap, _objectSpread(_objectSpread({}, opts), {}, {
        layers: terrainLayers,
        moduleParameters: {
          heightMapBounds: this.heightMap.bounds,
          dummyHeightMap: this.dummyHeightMap,
          devicePixelRatio: 1,
          drawToTerrainHeightMap: true
        }
      }));
    }
  }, {
    key: "_updateTerrainCovers",
    value: function _updateTerrainCovers(terrainLayers, drapeLayers, viewport, opts) {
      var layerNeedsRedraw = {};

      var _iterator3 = _createForOfIteratorHelper(drapeLayers),
          _step3;

      try {
        for (_iterator3.s(); !(_step3 = _iterator3.n()).done;) {
          var layer = _step3.value;

          if (layer.state.terrainCoverNeedsRedraw) {
            layerNeedsRedraw[layer.id] = true;
            layer.state.terrainCoverNeedsRedraw = false;
          }
        }
      } catch (err) {
        _iterator3.e(err);
      } finally {
        _iterator3.f();
      }

      var _iterator4 = _createForOfIteratorHelper(this.terrainCovers.values()),
          _step4;

      try {
        for (_iterator4.s(); !(_step4 = _iterator4.n()).done;) {
          var terrainCover = _step4.value;
          terrainCover.isDirty = terrainCover.isDirty || terrainCover.shouldUpdate({
            layerNeedsRedraw: layerNeedsRedraw
          });
        }
      } catch (err) {
        _iterator4.e(err);
      } finally {
        _iterator4.f();
      }

      var _iterator5 = _createForOfIteratorHelper(terrainLayers),
          _step5;

      try {
        for (_iterator5.s(); !(_step5 = _iterator5.n()).done;) {
          var _layer = _step5.value;

          this._updateTerrainCover(_layer, drapeLayers, viewport, opts);
        }
      } catch (err) {
        _iterator5.e(err);
      } finally {
        _iterator5.f();
      }

      if (!this.isPicking) {
        this._pruneTerrainCovers();
      }
    }
  }, {
    key: "_updateTerrainCover",
    value: function _updateTerrainCover(terrainLayer, drapeLayers, viewport, opts) {
      var renderPass = this.isPicking ? this.terrainPickingPass : this.terrainPass;
      var terrainCover = this.terrainCovers.get(terrainLayer.id);

      if (!terrainCover) {
        terrainCover = new _terrainCover.TerrainCover(terrainLayer);
        this.terrainCovers.set(terrainLayer.id, terrainCover);
      }

      try {
        var isDirty = terrainCover.shouldUpdate({
          targetLayer: terrainLayer,
          viewport: viewport,
          layers: drapeLayers
        });

        if (this.isPicking || terrainCover.isDirty || isDirty) {
          renderPass.renderTerrainCover(terrainCover, _objectSpread(_objectSpread({}, opts), {}, {
            layers: drapeLayers,
            moduleParameters: {
              dummyHeightMap: this.dummyHeightMap,
              terrainSkipRender: false,
              devicePixelRatio: 1
            }
          }));

          if (!this.isPicking) {
            terrainCover.isDirty = false;
          }
        }
      } catch (err) {
        terrainLayer.raiseError(err, "Error rendering terrain cover ".concat(terrainCover.id));
      }
    }
  }, {
    key: "_pruneTerrainCovers",
    value: function _pruneTerrainCovers() {
      var idsToRemove = [];

      var _iterator6 = _createForOfIteratorHelper(this.terrainCovers),
          _step6;

      try {
        for (_iterator6.s(); !(_step6 = _iterator6.n()).done;) {
          var _step6$value = (0, _slicedToArray2.default)(_step6.value, 2),
              _id = _step6$value[0],
              terrainCover = _step6$value[1];

          if (!terrainCover.isActive) {
            idsToRemove.push(_id);
          }
        }
      } catch (err) {
        _iterator6.e(err);
      } finally {
        _iterator6.f();
      }

      for (var _i = 0, _idsToRemove = idsToRemove; _i < _idsToRemove.length; _i++) {
        var id = _idsToRemove[_i];
        this.terrainCovers.delete(id);
      }
    }
  }]);
  return TerrainEffect;
}();

exports.TerrainEffect = TerrainEffect;
//# sourceMappingURL=terrain-effect.js.map