"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _core = require("@deck.gl/core");

var _terrainEffect = require("./terrain-effect");

var _shaderModule = require("./shader-module");

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

var defaultProps = {
  terrainDrawMode: undefined
};

var TerrainExtension = function (_LayerExtension) {
  (0, _inherits2.default)(TerrainExtension, _LayerExtension);

  var _super = _createSuper(TerrainExtension);

  function TerrainExtension() {
    (0, _classCallCheck2.default)(this, TerrainExtension);
    return _super.apply(this, arguments);
  }

  (0, _createClass2.default)(TerrainExtension, [{
    key: "getShaders",
    value: function getShaders() {
      return {
        modules: [_shaderModule.terrainModule]
      };
    }
  }, {
    key: "initializeState",
    value: function initializeState() {
      var _this$context$deck;

      (_this$context$deck = this.context.deck) === null || _this$context$deck === void 0 ? void 0 : _this$context$deck._addDefaultEffect(new _terrainEffect.TerrainEffect());
    }
  }, {
    key: "updateState",
    value: function updateState(params) {
      var props = params.props,
          oldProps = params.oldProps;

      if (this.state.terrainDrawMode && props.terrainDrawMode === oldProps.terrainDrawMode && props.extruded === oldProps.extruded) {
        return;
      }

      var terrainDrawMode = props.terrainDrawMode;

      if (!terrainDrawMode) {
        var _this$getAttributeMan;

        var is3d = this.props.extruded;
        var attributes = (_this$getAttributeMan = this.getAttributeManager()) === null || _this$getAttributeMan === void 0 ? void 0 : _this$getAttributeMan.attributes;
        var hasAnchor = attributes && 'instancePositions' in attributes;
        terrainDrawMode = is3d || hasAnchor ? 'offset' : 'drape';
      }

      this.setState({
        terrainDrawMode: terrainDrawMode
      });
    }
  }, {
    key: "onNeedsRedraw",
    value: function onNeedsRedraw() {
      var state = this.state;

      if (state.terrainDrawMode === 'drape') {
        state.terrainCoverNeedsRedraw = true;
      }
    }
  }]);
  return TerrainExtension;
}(_core.LayerExtension);

exports.default = TerrainExtension;
(0, _defineProperty2.default)(TerrainExtension, "defaultProps", defaultProps);
(0, _defineProperty2.default)(TerrainExtension, "extensionName", 'TerrainExtension');
//# sourceMappingURL=terrain-extension.js.map