"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TerrainPass = void 0;

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _core = require("@luma.gl/core");

var _core2 = require("@deck.gl/core");

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { (0, _defineProperty2.default)(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

var TerrainPass = function (_LayersPass) {
  (0, _inherits2.default)(TerrainPass, _LayersPass);

  var _super = _createSuper(TerrainPass);

  function TerrainPass() {
    (0, _classCallCheck2.default)(this, TerrainPass);
    return _super.apply(this, arguments);
  }

  (0, _createClass2.default)(TerrainPass, [{
    key: "getRenderableLayers",
    value: function getRenderableLayers(viewport, opts) {
      var layers = opts.layers;
      var result = [];

      var drawParamsByIndex = this._getDrawLayerParams(viewport, opts, true);

      for (var i = 0; i < layers.length; i++) {
        var layer = layers[i];

        if (!layer.isComposite && drawParamsByIndex[i].shouldDrawLayer) {
          result.push(layer);
        }
      }

      return result;
    }
  }, {
    key: "renderHeightMap",
    value: function renderHeightMap(heightMap, opts) {
      var _this = this;

      var target = heightMap.getRenderFramebuffer();
      var viewport = heightMap.renderViewport;

      if (!target || !viewport) {
        return;
      }

      target.resize(viewport);
      (0, _core.withParameters)(this.gl, {
        clearColor: [0, 0, 0, 0],
        blend: true,
        blendFunc: [1, 1],
        blendEquation: 32776,
        depthTest: false
      }, function () {
        return _this.render(_objectSpread(_objectSpread({}, opts), {}, {
          target: target,
          pass: 'terrain-height-map',
          layers: opts.layers,
          viewports: [viewport],
          effects: []
        }));
      });
    }
  }, {
    key: "renderTerrainCover",
    value: function renderTerrainCover(terrainCover, opts) {
      var _this2 = this;

      var target = terrainCover.getRenderFramebuffer();
      var viewport = terrainCover.renderViewport;

      if (!target || !viewport) {
        return;
      }

      var layers = terrainCover.filterLayers(opts.layers);
      target.resize(viewport);
      (0, _core.withParameters)(this.gl, {
        clearColor: [0, 0, 0, 0],
        depthTest: false
      }, function () {
        return _this2.render(_objectSpread(_objectSpread({}, opts), {}, {
          target: target,
          pass: "terrain-cover-".concat(terrainCover.id),
          layers: layers,
          effects: [],
          viewports: [viewport]
        }));
      });
    }
  }]);
  return TerrainPass;
}(_core2._LayersPass);

exports.TerrainPass = TerrainPass;
//# sourceMappingURL=terrain-pass.js.map