"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TerrainPickingPass = void 0;

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _assertThisInitialized2 = _interopRequireDefault(require("@babel/runtime/helpers/assertThisInitialized"));

var _get2 = _interopRequireDefault(require("@babel/runtime/helpers/get"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _core = require("@deck.gl/core");

var _core2 = require("@luma.gl/core");

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { (0, _defineProperty2.default)(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

var TerrainPickingPass = function (_PickLayersPass) {
  (0, _inherits2.default)(TerrainPickingPass, _PickLayersPass);

  var _super = _createSuper(TerrainPickingPass);

  function TerrainPickingPass() {
    var _this;

    (0, _classCallCheck2.default)(this, TerrainPickingPass);

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    _this = _super.call.apply(_super, [this].concat(args));
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "drawParameters", {});
    return _this;
  }

  (0, _createClass2.default)(TerrainPickingPass, [{
    key: "getRenderableLayers",
    value: function getRenderableLayers(viewport, opts) {
      var layers = opts.layers;
      var result = [];
      this.drawParameters = {};

      this._resetColorEncoder(opts.pickZ);

      var drawParamsByIndex = this._getDrawLayerParams(viewport, opts);

      for (var i = 0; i < layers.length; i++) {
        var layer = layers[i];

        if (!layer.isComposite && drawParamsByIndex[i].shouldDrawLayer) {
          result.push(layer);
          this.drawParameters[layer.id] = drawParamsByIndex[i].layerParameters;
        }
      }

      return result;
    }
  }, {
    key: "renderTerrainCover",
    value: function renderTerrainCover(terrainCover, opts) {
      var _this2 = this;

      var target = terrainCover.getPickingFramebuffer();
      var viewport = terrainCover.renderViewport;

      if (!target || !viewport) {
        return;
      }

      var layers = terrainCover.filterLayers(opts.layers);
      var terrainLayer = terrainCover.targetLayer;

      if (terrainLayer.props.pickable) {
        layers.unshift(terrainLayer);
      }

      target.resize(viewport);
      (0, _core2.withParameters)(this.gl, {
        depthTest: false
      }, function () {
        return _this2.render(_objectSpread(_objectSpread({}, opts), {}, {
          pickingFBO: target,
          pass: "terrain-cover-picking-".concat(terrainCover.id),
          layers: layers,
          effects: [],
          viewports: [viewport],
          cullRect: undefined,
          deviceRect: viewport,
          pickZ: false
        }));
      });
    }
  }, {
    key: "getLayerParameters",
    value: function getLayerParameters(layer, layerIndex, viewport) {
      if (this.drawParameters[layer.id]) {
        return this.drawParameters[layer.id];
      }

      var parameters = (0, _get2.default)((0, _getPrototypeOf2.default)(TerrainPickingPass.prototype), "getLayerParameters", this).call(this, layer, layerIndex, viewport);
      parameters.blend = true;
      return parameters;
    }
  }]);
  return TerrainPickingPass;
}(_core._PickLayersPass);

exports.TerrainPickingPass = TerrainPickingPass;
//# sourceMappingURL=terrain-picking-pass.js.map