"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.debugFBO = void 0;

var _core = require("@luma.gl/core");

var debugFBO = function debugFBO(fbo) {
  var _ref = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {},
      minimap = _ref.minimap,
      opaque = _ref.opaque;

  var color = (0, _core.readPixelsToArray)(fbo);
  var canvas = document.getElementById('fbo-canvas');
  var canvasHeight = (minimap ? 2 : 1) * fbo.height;

  if (!canvas) {
    canvas = document.createElement('canvas');
    canvas.id = 'fbo-canvas';
    canvas.style.zIndex = '100';
    canvas.style.position = 'absolute';
    canvas.style.top = '0';
    canvas.style.right = '0';
    canvas.style.border = 'blue 1px solid';
    canvas.style.transform = 'scaleY(-1)';
    document.body.appendChild(canvas);
  }

  if (canvas.width !== fbo.width || canvas.height !== canvasHeight) {
    canvas.width = fbo.width;
    canvas.height = canvasHeight;
    canvas.style.width = '400px';
  }

  var ctx = canvas.getContext('2d');
  var imageData = ctx.createImageData(canvas.width, canvas.height);

  if (minimap) {
    var zoom = 8;
    var _canvas = canvas,
        width = _canvas.width,
        height = _canvas.height;

    for (var y = 0; y < height; y++) {
      for (var x = 0; x < width; x++) {
        var d = 4 * (x + y * width);
        var s = 4 * (Math.floor(x / zoom) + Math.floor(y / zoom) * width);
        imageData.data[d + 0] = color[s + 0];
        imageData.data[d + 1] = color[s + 1];
        imageData.data[d + 2] = color[s + 2];
        imageData.data[d + 3] = opaque ? 255 : color[s + 3];
      }
    }
  }

  var offset = minimap ? color.length : 0;

  for (var i = 0; i < color.length; i += 4) {
    imageData.data[offset + i + 0] = color[i + 0];
    imageData.data[offset + i + 1] = color[i + 1];
    imageData.data[offset + i + 2] = color[i + 2];
    imageData.data[offset + i + 3] = opaque ? 255 : color[i + 3];
  }

  ctx.putImageData(imageData, 0, 0);
};

exports.debugFBO = debugFBO;
//# sourceMappingURL=debug.js.map