"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.joinLayerBounds = joinLayerBounds;
exports.makeViewport = makeViewport;
exports.getViewportBounds = getViewportBounds;
exports.getRenderBounds = getRenderBounds;

var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));

var _core = require("@deck.gl/core");

function _createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it.return != null) it.return(); } finally { if (didErr) throw err; } } }; }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function joinLayerBounds(layers, viewport) {
  var bounds = [Infinity, Infinity, -Infinity, -Infinity];

  var _iterator = _createForOfIteratorHelper(layers),
      _step;

  try {
    for (_iterator.s(); !(_step = _iterator.n()).done;) {
      var layer = _step.value;
      var layerBounds = layer.getBounds();

      if (layerBounds) {
        var bottomLeftCommon = layer.projectPosition(layerBounds[0], {
          viewport: viewport,
          autoOffset: false
        });
        var topRightCommon = layer.projectPosition(layerBounds[1], {
          viewport: viewport,
          autoOffset: false
        });
        bounds[0] = Math.min(bounds[0], bottomLeftCommon[0]);
        bounds[1] = Math.min(bounds[1], bottomLeftCommon[1]);
        bounds[2] = Math.max(bounds[2], topRightCommon[0]);
        bounds[3] = Math.max(bounds[3], topRightCommon[1]);
      }
    }
  } catch (err) {
    _iterator.e(err);
  } finally {
    _iterator.f();
  }

  if (Number.isFinite(bounds[0])) {
    return bounds;
  }

  return null;
}

var MAX_VIEWPORT_SIZE = 2048;

function makeViewport(opts) {
  var bounds = opts.bounds,
      viewport = opts.viewport,
      _opts$border = opts.border,
      border = _opts$border === void 0 ? 0 : _opts$border;
  var isGeospatial = viewport.isGeospatial;

  if (bounds[2] <= bounds[0] || bounds[3] <= bounds[1]) {
    return null;
  }

  var centerWorld = viewport.unprojectPosition([(bounds[0] + bounds[2]) / 2, (bounds[1] + bounds[3]) / 2, 0]);
  var width = opts.width,
      height = opts.height,
      zoom = opts.zoom;

  if (zoom === undefined) {
    width = width - border * 2;
    height = height - border * 2;
    var scale = Math.min(width / (bounds[2] - bounds[0]), height / (bounds[3] - bounds[1]));
    zoom = Math.min(Math.log2(scale), 20);
  } else if (!width || !height) {
    var _scale = Math.pow(2, zoom);

    width = Math.round(Math.abs(bounds[2] - bounds[0]) * _scale);
    height = Math.round(Math.abs(bounds[3] - bounds[1]) * _scale);
    var maxSize = MAX_VIEWPORT_SIZE - border * 2;

    if (width > maxSize || height > maxSize) {
      var r = maxSize / Math.max(width, height);
      width = Math.round(width * r);
      height = Math.round(height * r);
      zoom += Math.log2(r);
    }
  }

  return isGeospatial ? new _core.WebMercatorViewport({
    id: viewport.id,
    x: border,
    y: border,
    width: width,
    height: height,
    longitude: centerWorld[0],
    latitude: centerWorld[1],
    zoom: zoom,
    orthographic: true
  }) : new _core.OrthographicViewport({
    id: viewport.id,
    x: border,
    y: border,
    width: width,
    height: height,
    target: centerWorld,
    zoom: zoom,
    flipY: false
  });
}

function getViewportBounds(viewport, zRange) {
  var viewportBoundsWorld;

  if (zRange && zRange.length === 2) {
    var _zRange = (0, _slicedToArray2.default)(zRange, 2),
        minZ = _zRange[0],
        maxZ = _zRange[1];

    var bounds0 = viewport.getBounds({
      z: minZ
    });
    var bounds1 = viewport.getBounds({
      z: maxZ
    });
    viewportBoundsWorld = [Math.min(bounds0[0], bounds1[0]), Math.min(bounds0[1], bounds1[1]), Math.max(bounds0[2], bounds1[2]), Math.max(bounds0[3], bounds1[3])];
  } else {
    viewportBoundsWorld = viewport.getBounds();
  }

  var viewportBottomLeftCommon = viewport.projectPosition(viewportBoundsWorld.slice(0, 2));
  var viewportTopRightCommon = viewport.projectPosition(viewportBoundsWorld.slice(2, 4));
  return [viewportBottomLeftCommon[0], viewportBottomLeftCommon[1], viewportTopRightCommon[0], viewportTopRightCommon[1]];
}

function getRenderBounds(layerBounds, viewport, zRange) {
  if (!layerBounds) {
    return [0, 0, 1, 1];
  }

  var viewportBounds = getViewportBounds(viewport, zRange);
  var paddedBounds = doubleBounds(viewportBounds);

  if (layerBounds[2] - layerBounds[0] <= paddedBounds[2] - paddedBounds[0] && layerBounds[3] - layerBounds[1] <= paddedBounds[3] - paddedBounds[1]) {
    return layerBounds;
  }

  return [Math.max(layerBounds[0], paddedBounds[0]), Math.max(layerBounds[1], paddedBounds[1]), Math.min(layerBounds[2], paddedBounds[2]), Math.min(layerBounds[3], paddedBounds[3])];
}

function doubleBounds(bounds) {
  var dx = bounds[2] - bounds[0];
  var dy = bounds[3] - bounds[1];
  var centerX = (bounds[0] + bounds[2]) / 2;
  var centerY = (bounds[1] + bounds[3]) / 2;
  return [centerX - dx, centerY - dy, centerX + dx, centerY + dy];
}
//# sourceMappingURL=projection-utils.js.map