import _defineProperty from "@babel/runtime/helpers/esm/defineProperty";
import { LayerExtension } from '@deck.gl/core';
import shaderModule from './shader-module';
const defaultProps = {
  getBrushingTarget: {
    type: 'accessor',
    value: [0, 0]
  },
  brushingTarget: 'source',
  brushingEnabled: true,
  brushingRadius: 10000
};
export default class BrushingExtension extends LayerExtension {
  getShaders() {
    return {
      modules: [shaderModule]
    };
  }

  initializeState(context, extension) {
    const attributeManager = this.getAttributeManager();

    if (attributeManager) {
      attributeManager.add({
        brushingTargets: {
          size: 2,
          accessor: 'getBrushingTarget',
          shaderAttributes: {
            brushingTargets: {
              divisor: 0
            },
            instanceBrushingTargets: {
              divisor: 1
            }
          }
        }
      });
    }

    this.state.onMouseMove = () => {
      var _this$getCurrentLayer;

      (_this$getCurrentLayer = this.getCurrentLayer()) === null || _this$getCurrentLayer === void 0 ? void 0 : _this$getCurrentLayer.setNeedsRedraw();
    };

    if (context.deck) {
      context.deck.eventManager.on({
        pointermove: this.state.onMouseMove,
        pointerleave: this.state.onMouseMove
      });
    }
  }

  finalizeState(context, extension) {
    if (context.deck) {
      context.deck.eventManager.off({
        pointermove: this.state.onMouseMove,
        pointerleave: this.state.onMouseMove
      });
    }
  }

}

_defineProperty(BrushingExtension, "defaultProps", defaultProps);

_defineProperty(BrushingExtension, "extensionName", 'BrushingExtension');
//# sourceMappingURL=brushing-extension.js.map