import _defineProperty from "@babel/runtime/helpers/esm/defineProperty";
import { LayerExtension } from '@deck.gl/core';
import collision from './shader-module';
import CollisionFilterEffect from './collision-filter-effect';
const defaultProps = {
  getCollisionPriority: {
    type: 'accessor',
    value: 0
  },
  collisionEnabled: true,
  collisionGroup: {
    type: 'string',
    value: 'default'
  },
  collisionTestProps: {}
};
export default class CollisionFilterExtension extends LayerExtension {
  getShaders() {
    return {
      modules: [collision]
    };
  }

  draw({
    uniforms,
    context,
    moduleParameters
  }) {
    const {
      collisionEnabled
    } = this.props;
    const {
      collisionFBO,
      drawToCollisionMap
    } = moduleParameters;
    const enabled = collisionEnabled && Boolean(collisionFBO);
    uniforms.collision_enabled = enabled;

    if (drawToCollisionMap) {
      this.props = this.clone(this.props.collisionTestProps).props;
    }
  }

  initializeState(context, extension) {
    var _this$context$deck;

    if (this.getAttributeManager() === null) {
      return;
    }

    (_this$context$deck = this.context.deck) === null || _this$context$deck === void 0 ? void 0 : _this$context$deck._addDefaultEffect(new CollisionFilterEffect());
    const attributeManager = this.getAttributeManager();
    attributeManager.add({
      collisionPriorities: {
        size: 1,
        accessor: 'getCollisionPriority',
        shaderAttributes: {
          collisionPriorities: {
            divisor: 0
          },
          instanceCollisionPriorities: {
            divisor: 1
          }
        }
      }
    });
  }

  getNeedsPickingBuffer() {
    return this.props.collisionEnabled;
  }

}

_defineProperty(CollisionFilterExtension, "defaultProps", defaultProps);

_defineProperty(CollisionFilterExtension, "extensionName", 'CollisionFilterExtension');
//# sourceMappingURL=collision-filter-extension.js.map