import { withParameters } from '@luma.gl/core';
import { _LayersPass as LayersPass } from '@deck.gl/core';
export default class CollisionFilterPass extends LayersPass {
  renderCollisionMap(target, options) {
    const gl = this.gl;
    const padding = 1;
    return withParameters(gl, {
      scissorTest: true,
      scissor: [padding, padding, target.width - 2 * padding, target.height - 2 * padding],
      clearColor: [0, 0, 0, 0],
      blend: false,
      depthTest: true,
      depthRange: [0, 1]
    }, () => this.render({ ...options,
      target,
      pass: 'collision'
    }));
  }

  getModuleParameters() {
    return {
      drawToCollisionMap: true,
      pickingActive: 1,
      pickingAttribute: false,
      lightSources: {}
    };
  }

}
//# sourceMappingURL=collision-filter-pass.js.map