import { project } from '@deck.gl/core';
const vs = "\n#ifdef NON_INSTANCED_MODEL\nattribute float collisionPriorities;\n#else\nattribute float instanceCollisionPriorities;\n#endif\n\nuniform sampler2D collision_texture;\nuniform bool collision_sort;\nuniform bool collision_enabled;\n\nvec2 collision_getCoords(vec4 position) {\n  vec4 collision_clipspace = project_common_position_to_clipspace(position);\n  return (1.0 + collision_clipspace.xy / collision_clipspace.w) / 2.0;\n}\n\nfloat collision_match(vec2 tex, vec3 pickingColor) {\n  vec4 collision_pickingColor = texture2D(collision_texture, tex);\n  float delta = dot(abs(collision_pickingColor.rgb - pickingColor), vec3(1.0));\n  float e = 0.001;\n  return step(delta, e);\n}\n\nfloat collision_isVisible(vec2 texCoords, vec3 pickingColor) {\n  if (!collision_enabled) {\n    return 1.0;\n  }\n\n  // Visibility test, sample area of 5x5 pixels in order to fade in/out.\n  // Due to the locality, the lookups will be cached\n  // This reduces the flicker present when objects are shown/hidden\n  const int N = 2;\n  float accumulator = 0.0;\n  vec2 step = vec2(1.0 / project_uViewportSize);\n\n  const float floatN = float(N);\n  vec2 delta = -floatN * step;\n  for(int i = -N; i <= N; i++) {\n    delta.x = -step.x * floatN;\n    for(int j = -N; j <= N; j++) {\n      accumulator += collision_match(texCoords + delta, pickingColor);\n      delta.x += step.x;\n    }\n    delta.y += step.y;\n  }\n\n  float W = 2.0 * floatN + 1.0;\n  return pow(accumulator / (W * W), 2.2);\n}\n";
const inject = {
  'vs:#decl': "\n  float collision_fade = 1.0;\n",
  'vs:DECKGL_FILTER_GL_POSITION': "\n  if (collision_sort) {\n    #ifdef NON_INSTANCED_MODEL\n    float collisionPriority = collisionPriorities;\n    #else\n    float collisionPriority = instanceCollisionPriorities;\n    #endif\n    position.z = -0.001 * collisionPriority * position.w; // Support range -1000 -> 1000\n  }\n\n  if (collision_enabled) {\n    vec4 collision_common_position = project_position(vec4(geometry.worldPosition, 1.0));\n    vec2 collision_texCoords = collision_getCoords(collision_common_position);\n    collision_fade = collision_isVisible(collision_texCoords, geometry.pickingColor / 255.0);\n    if (collision_fade < 0.0001) {\n      // Position outside clip space bounds to discard\n      position = vec4(0.0, 0.0, 2.0, 1.0);\n    }\n  }\n  ",
  'vs:DECKGL_FILTER_COLOR': "\n  color.a *= collision_fade;\n  "
};

const getCollisionUniforms = (opts, uniforms) => {
  if (!opts || !('dummyCollisionMap' in opts)) {
    return {};
  }

  const {
    collisionFBO,
    drawToCollisionMap,
    dummyCollisionMap
  } = opts;
  return {
    collision_sort: Boolean(drawToCollisionMap),
    collision_texture: !drawToCollisionMap && collisionFBO ? collisionFBO : dummyCollisionMap
  };
};

export default {
  name: 'collision',
  dependencies: [project],
  vs,
  inject,
  getUniforms: getCollisionUniforms
};
//# sourceMappingURL=shader-module.js.map