const vs = "\nuniform DATAFILTER_TYPE filter_min;\nuniform DATAFILTER_TYPE filter_softMin;\nuniform DATAFILTER_TYPE filter_softMax;\nuniform DATAFILTER_TYPE filter_max;\nuniform bool filter_useSoftMargin;\nuniform bool filter_enabled;\nuniform bool filter_transformSize;\n\n#ifdef NON_INSTANCED_MODEL\n  #define DATAFILTER_ATTRIB filterValues\n  #define DATAFILTER_ATTRIB_64LOW filterValues64Low\n#else\n  #define DATAFILTER_ATTRIB instanceFilterValues\n  #define DATAFILTER_ATTRIB_64LOW instanceFilterValues64Low\n#endif\n\nattribute DATAFILTER_TYPE DATAFILTER_ATTRIB;\n#ifdef DATAFILTER_DOUBLE\n  attribute DATAFILTER_TYPE DATAFILTER_ATTRIB_64LOW;\n\n  uniform DATAFILTER_TYPE filter_min64High;\n  uniform DATAFILTER_TYPE filter_max64High;\n#endif\n\nvarying float dataFilter_value;\n\nfloat dataFilter_reduceValue(float value) {\n  return value;\n}\nfloat dataFilter_reduceValue(vec2 value) {\n  return min(value.x, value.y);\n}\nfloat dataFilter_reduceValue(vec3 value) {\n  return min(min(value.x, value.y), value.z);\n}\nfloat dataFilter_reduceValue(vec4 value) {\n  return min(min(value.x, value.y), min(value.z, value.w));\n}\nvoid dataFilter_setValue(DATAFILTER_TYPE valueFromMin, DATAFILTER_TYPE valueFromMax) {\n  if (filter_enabled) {\n    if (filter_useSoftMargin) {\n      dataFilter_value = dataFilter_reduceValue(\n        smoothstep(filter_min, filter_softMin, valueFromMin) *\n        (1.0 - smoothstep(filter_softMax, filter_max, valueFromMax))\n      );\n    } else {\n      dataFilter_value = dataFilter_reduceValue(\n        step(filter_min, valueFromMin) * step(valueFromMax, filter_max)\n      );\n    }\n  } else {\n    dataFilter_value = 1.0;\n  }\n}\n";
const fs = "\nuniform bool filter_transformColor;\nvarying float dataFilter_value;\n";

function getUniforms(opts) {
  if (!opts || !('extensions' in opts)) {
    return {};
  }

  const {
    filterRange = [-1, 1],
    filterEnabled = true,
    filterTransformSize = true,
    filterTransformColor = true
  } = opts;
  const filterSoftRange = opts.filterSoftRange || filterRange;
  return { ...(Number.isFinite(filterRange[0]) ? {
      filter_min: filterRange[0],
      filter_softMin: filterSoftRange[0],
      filter_softMax: filterSoftRange[1],
      filter_max: filterRange[1]
    } : {
      filter_min: filterRange.map(r => r[0]),
      filter_softMin: filterSoftRange.map(r => r[0]),
      filter_softMax: filterSoftRange.map(r => r[1]),
      filter_max: filterRange.map(r => r[1])
    }),
    filter_enabled: filterEnabled,
    filter_useSoftMargin: Boolean(opts.filterSoftRange),
    filter_transformSize: filterEnabled && filterTransformSize,
    filter_transformColor: filterEnabled && filterTransformColor
  };
}

function getUniforms64(opts) {
  if (!opts || !('extensions' in opts)) {
    return {};
  }

  const uniforms = getUniforms(opts);

  if (Number.isFinite(uniforms.filter_min)) {
    const min64High = Math.fround(uniforms.filter_min);
    uniforms.filter_min -= min64High;
    uniforms.filter_softMin -= min64High;
    uniforms.filter_min64High = min64High;
    const max64High = Math.fround(uniforms.filter_max);
    uniforms.filter_max -= max64High;
    uniforms.filter_softMax -= max64High;
    uniforms.filter_max64High = max64High;
  } else {
    const min64High = uniforms.filter_min.map(Math.fround);
    uniforms.filter_min = uniforms.filter_min.map((x, i) => x - min64High[i]);
    uniforms.filter_softMin = uniforms.filter_softMin.map((x, i) => x - min64High[i]);
    uniforms.filter_min64High = min64High;
    const max64High = uniforms.filter_max.map(Math.fround);
    uniforms.filter_max = uniforms.filter_max.map((x, i) => x - max64High[i]);
    uniforms.filter_softMax = uniforms.filter_softMax.map((x, i) => x - max64High[i]);
    uniforms.filter_max64High = max64High;
  }

  return uniforms;
}

const inject = {
  'vs:#main-start': "\n    #ifdef DATAFILTER_DOUBLE\n      dataFilter_setValue(\n        DATAFILTER_ATTRIB - filter_min64High + DATAFILTER_ATTRIB_64LOW,\n        DATAFILTER_ATTRIB - filter_max64High + DATAFILTER_ATTRIB_64LOW\n      );\n    #else\n      dataFilter_setValue(DATAFILTER_ATTRIB, DATAFILTER_ATTRIB);\n    #endif\n  ",
  'vs:#main-end': "\n    if (dataFilter_value == 0.0) {\n      gl_Position = vec4(0.);\n    }\n  ",
  'vs:DECKGL_FILTER_SIZE': "\n    if (filter_transformSize) {\n      size = size * dataFilter_value;\n    }\n  ",
  'fs:DECKGL_FILTER_COLOR': "\n    if (dataFilter_value == 0.0) discard;\n    if (filter_transformColor) {\n      color.a *= dataFilter_value;\n    }\n  "
};
export const shaderModule = {
  name: 'data-filter',
  vs,
  fs,
  inject,
  getUniforms
};
export const shaderModule64 = {
  name: 'data-filter-fp64',
  vs,
  fs,
  inject,
  getUniforms: getUniforms64
};
//# sourceMappingURL=shader-module.js.map