import _defineProperty from "@babel/runtime/helpers/esm/defineProperty";
import { LayerExtension } from '@deck.gl/core';
import { Texture2D } from '@luma.gl/core';
import { patternShaders } from './shaders.glsl';
const defaultProps = {
  fillPatternEnabled: true,
  fillPatternAtlas: {
    type: 'image',
    value: null,
    async: true,
    parameters: {
      [10241]: 9729
    }
  },
  fillPatternMapping: {
    type: 'object',
    value: {},
    async: true
  },
  fillPatternMask: true,
  getFillPattern: {
    type: 'accessor',
    value: d => d.pattern
  },
  getFillPatternScale: {
    type: 'accessor',
    value: 1
  },
  getFillPatternOffset: {
    type: 'accessor',
    value: [0, 0]
  }
};
export default class FillStyleExtension extends LayerExtension {
  constructor({
    pattern = false
  } = {}) {
    super({
      pattern
    });
  }

  isEnabled(layer) {
    return layer.getAttributeManager() !== null && !('pathTesselator' in layer.state);
  }

  getShaders(extension) {
    if (!extension.isEnabled(this)) {
      return null;
    }

    return {
      modules: [extension.opts.pattern && patternShaders].filter(Boolean)
    };
  }

  initializeState(context, extension) {
    if (!extension.isEnabled(this)) {
      return;
    }

    const attributeManager = this.getAttributeManager();

    if (extension.opts.pattern) {
      attributeManager.add({
        fillPatternFrames: {
          size: 4,
          accessor: 'getFillPattern',
          transform: extension.getPatternFrame.bind(this),
          shaderAttributes: {
            fillPatternFrames: {
              divisor: 0
            },
            instanceFillPatternFrames: {
              divisor: 1
            }
          }
        },
        fillPatternScales: {
          size: 1,
          accessor: 'getFillPatternScale',
          defaultValue: 1,
          shaderAttributes: {
            fillPatternScales: {
              divisor: 0
            },
            instanceFillPatternScales: {
              divisor: 1
            }
          }
        },
        fillPatternOffsets: {
          size: 2,
          accessor: 'getFillPatternOffset',
          shaderAttributes: {
            fillPatternOffsets: {
              divisor: 0
            },
            instanceFillPatternOffsets: {
              divisor: 1
            }
          }
        }
      });
    }

    this.setState({
      emptyTexture: new Texture2D(this.context.gl, {
        data: new Uint8Array(4),
        width: 1,
        height: 1
      })
    });
  }

  updateState({
    props,
    oldProps
  }, extension) {
    if (!extension.isEnabled(this)) {
      return;
    }

    if (props.fillPatternMapping && props.fillPatternMapping !== oldProps.fillPatternMapping) {
      this.getAttributeManager().invalidate('getFillPattern');
    }
  }

  draw(params, extension) {
    if (!extension.isEnabled(this)) {
      return;
    }

    const {
      fillPatternAtlas
    } = this.props;
    this.setModuleParameters({
      fillPatternTexture: fillPatternAtlas || this.state.emptyTexture
    });
  }

  finalizeState() {
    const {
      emptyTexture
    } = this.state;
    emptyTexture === null || emptyTexture === void 0 ? void 0 : emptyTexture.delete();
  }

  getPatternFrame(name) {
    const {
      fillPatternMapping
    } = this.getCurrentLayer().props;
    const def = fillPatternMapping && fillPatternMapping[name];
    return def ? [def.x, def.y, def.width, def.height] : [0, 0, 0, 0];
  }

}

_defineProperty(FillStyleExtension, "defaultProps", defaultProps);

_defineProperty(FillStyleExtension, "extensionName", 'FillStyleExtension');
//# sourceMappingURL=fill-style-extension.js.map