import { project, fp64LowPart } from '@deck.gl/core';
const patternVs = "\n#ifdef NON_INSTANCED_MODEL\n  #define FILL_PATTERN_FRAME_ATTRIB fillPatternFrames\n  #define FILL_PATTERN_SCALE_ATTRIB fillPatternScales\n  #define FILL_PATTERN_OFFSET_ATTRIB fillPatternOffsets\n#else\n  #define FILL_PATTERN_FRAME_ATTRIB instanceFillPatternFrames\n  #define FILL_PATTERN_SCALE_ATTRIB instanceFillPatternScales\n  #define FILL_PATTERN_OFFSET_ATTRIB instanceFillPatternOffsets\n#endif\n\nattribute vec4 FILL_PATTERN_FRAME_ATTRIB;\nattribute float FILL_PATTERN_SCALE_ATTRIB;\nattribute vec2 FILL_PATTERN_OFFSET_ATTRIB;\n\nuniform bool fill_patternEnabled;\nuniform vec2 fill_patternTextureSize;\n\nvarying vec2 fill_uv;\nvarying vec4 fill_patternBounds;\nvarying vec4 fill_patternPlacement;\n";
const patternFs = "\nuniform bool fill_patternEnabled;\nuniform bool fill_patternMask;\nuniform sampler2D fill_patternTexture;\nuniform vec2 fill_uvCoordinateOrigin;\nuniform vec2 fill_uvCoordinateOrigin64Low;\n\nvarying vec4 fill_patternBounds;\nvarying vec4 fill_patternPlacement;\nvarying vec2 fill_uv;\n\nconst float FILL_UV_SCALE = 512.0 / 40000000.0;\n";
const inject = {
  'vs:DECKGL_FILTER_GL_POSITION': "\n    fill_uv = geometry.position.xy;\n  ",
  'vs:DECKGL_FILTER_COLOR': "\n    if (fill_patternEnabled) {\n      fill_patternBounds = FILL_PATTERN_FRAME_ATTRIB / vec4(fill_patternTextureSize, fill_patternTextureSize);\n      fill_patternPlacement.xy = FILL_PATTERN_OFFSET_ATTRIB;\n      fill_patternPlacement.zw = FILL_PATTERN_SCALE_ATTRIB * FILL_PATTERN_FRAME_ATTRIB.zw;\n    }\n  ",
  'fs:DECKGL_FILTER_COLOR': "\n    if (fill_patternEnabled) {\n      vec2 scale = FILL_UV_SCALE * fill_patternPlacement.zw;\n      vec2 patternUV = mod(mod(fill_uvCoordinateOrigin, scale) + fill_uvCoordinateOrigin64Low + fill_uv, scale) / scale;\n      patternUV = mod(fill_patternPlacement.xy + patternUV, 1.0);\n\n      vec2 texCoords = fill_patternBounds.xy + fill_patternBounds.zw * patternUV;\n\n      vec4 patternColor = texture2D(fill_patternTexture, texCoords);\n      color.a *= patternColor.a;\n      if (!fill_patternMask) {\n        color.rgb = patternColor.rgb;\n      }\n    }\n  "
};

function getPatternUniforms(opts, uniforms) {
  if (!opts) {
    return {};
  }

  if ('fillPatternTexture' in opts) {
    const {
      fillPatternTexture
    } = opts;
    return {
      fill_patternTexture: fillPatternTexture,
      fill_patternTextureSize: [fillPatternTexture.width, fillPatternTexture.height]
    };
  }

  if ('viewport' in opts) {
    const {
      fillPatternMask = true,
      fillPatternEnabled = true
    } = opts;
    const {
      project_uCommonOrigin: coordinateOriginCommon
    } = uniforms;
    const coordinateOriginCommon64Low = [fp64LowPart(coordinateOriginCommon[0]), fp64LowPart(coordinateOriginCommon[1])];
    return {
      fill_uvCoordinateOrigin: coordinateOriginCommon.slice(0, 2),
      fill_uvCoordinateOrigin64Low: coordinateOriginCommon64Low,
      fill_patternMask: fillPatternMask,
      fill_patternEnabled: fillPatternEnabled
    };
  }

  return {};
}

export const patternShaders = {
  name: 'fill-pattern',
  vs: patternVs,
  fs: patternFs,
  inject,
  dependencies: [project],
  getUniforms: getPatternUniforms
};
//# sourceMappingURL=shaders.glsl.js.map