import _defineProperty from "@babel/runtime/helpers/esm/defineProperty";
import { LayerExtension, COORDINATE_SYSTEM } from '@deck.gl/core';
import project64 from './project64';
export default class Fp64Extension extends LayerExtension {
  getShaders() {
    const {
      coordinateSystem
    } = this.props;

    if (coordinateSystem !== COORDINATE_SYSTEM.LNGLAT && coordinateSystem !== COORDINATE_SYSTEM.DEFAULT) {
      throw new Error('fp64: coordinateSystem must be LNGLAT');
    }

    return {
      modules: [project64]
    };
  }

}

_defineProperty(Fp64Extension, "extensionName", 'Fp64Extension');
//# sourceMappingURL=fp64-extension.js.map