import _defineProperty from "@babel/runtime/helpers/esm/defineProperty";
import { COORDINATE_SYSTEM, LayerExtension, log } from '@deck.gl/core';
import mask from './shader-module';
import MaskEffect from './mask-effect';
const defaultProps = {
  maskId: '',
  maskByInstance: undefined,
  maskInverted: false
};
export default class MaskExtension extends LayerExtension {
  initializeState() {
    var _this$context$deck;

    (_this$context$deck = this.context.deck) === null || _this$context$deck === void 0 ? void 0 : _this$context$deck._addDefaultEffect(new MaskEffect());
  }

  getShaders() {
    let maskByInstance = ('instancePositions' in this.getAttributeManager().attributes);

    if (this.props.maskByInstance !== undefined) {
      maskByInstance = Boolean(this.props.maskByInstance);
    }

    this.state.maskByInstance = maskByInstance;
    return {
      modules: [mask]
    };
  }

  draw({
    uniforms,
    context,
    moduleParameters
  }) {
    uniforms.mask_maskByInstance = this.state.maskByInstance;
    const {
      maskId,
      maskInverted
    } = this.props;
    const {
      maskChannels
    } = moduleParameters;
    const {
      viewport
    } = context;

    if (maskChannels && maskChannels[maskId]) {
      const {
        index,
        bounds,
        coordinateOrigin: fromCoordinateOrigin
      } = maskChannels[maskId];
      let {
        coordinateSystem: fromCoordinateSystem
      } = maskChannels[maskId];
      uniforms.mask_enabled = true;
      uniforms.mask_channel = index;
      uniforms.mask_inverted = maskInverted;

      if (fromCoordinateSystem === COORDINATE_SYSTEM.DEFAULT) {
        fromCoordinateSystem = viewport.isGeospatial ? COORDINATE_SYSTEM.LNGLAT : COORDINATE_SYSTEM.CARTESIAN;
      }

      const opts = {
        modelMatrix: null,
        fromCoordinateOrigin,
        fromCoordinateSystem
      };
      const bl = this.projectPosition([bounds[0], bounds[1], 0], opts);
      const tr = this.projectPosition([bounds[2], bounds[3], 0], opts);
      uniforms.mask_bounds = [bl[0], bl[1], tr[0], tr[1]];
    } else {
      if (maskId) {
        log.warn("Could not find a mask layer with id: ".concat(maskId))();
      }

      uniforms.mask_enabled = false;
    }
  }

}

_defineProperty(MaskExtension, "defaultProps", defaultProps);

_defineProperty(MaskExtension, "extensionName", 'MaskExtension');
//# sourceMappingURL=mask-extension.js.map