import _defineProperty from "@babel/runtime/helpers/esm/defineProperty";
import { Framebuffer, Texture2D, withParameters } from '@luma.gl/core';
import { _LayersPass as LayersPass } from '@deck.gl/core';
export default class MaskPass extends LayersPass {
  constructor(gl, props) {
    super(gl, props);

    _defineProperty(this, "maskMap", void 0);

    _defineProperty(this, "fbo", void 0);

    const {
      mapSize = 2048
    } = props;
    this.maskMap = new Texture2D(gl, {
      width: mapSize,
      height: mapSize,
      parameters: {
        [10241]: 9729,
        [10240]: 9729,
        [10242]: 33071,
        [10243]: 33071
      }
    });
    this.fbo = new Framebuffer(gl, {
      id: 'maskmap',
      width: mapSize,
      height: mapSize,
      attachments: {
        [36064]: this.maskMap
      }
    });
  }

  render(options) {
    const gl = this.gl;
    const colorMask = [false, false, false, false];
    colorMask[options.channel] = true;
    return withParameters(gl, {
      clearColor: [255, 255, 255, 255],
      blend: true,
      blendFunc: [0, 1],
      blendEquation: 32778,
      colorMask,
      depthTest: false
    }, () => super.render({ ...options,
      target: this.fbo,
      pass: 'mask'
    }));
  }

  shouldDrawLayer(layer) {
    return layer.props.operation.includes('mask');
  }

  delete() {
    this.fbo.delete();
    this.maskMap.delete();
  }

}
//# sourceMappingURL=mask-pass.js.map