import { project } from '@deck.gl/core';
const vs = "\nuniform vec4 mask_bounds;\nuniform bool mask_maskByInstance;\nvec2 mask_getCoords(vec4 position) {\n  return (position.xy - mask_bounds.xy) / (mask_bounds.zw - mask_bounds.xy);\n}\n";
const fs = "\nuniform sampler2D mask_texture;\nuniform int mask_channel;\nuniform bool mask_enabled;\nuniform bool mask_inverted;\nbool mask_isInBounds(vec2 texCoords) {\n  if (!mask_enabled) {\n    return true;\n  }\n  vec4 maskColor = texture2D(mask_texture, texCoords);\n  float maskValue = 1.0;\n  if (mask_channel == 0) {\n    maskValue = maskColor.r;\n  } else if (mask_channel == 1) {\n    maskValue = maskColor.g;\n  } else if (mask_channel == 2) {\n    maskValue = maskColor.b;\n  } else if (mask_channel == 3) {\n    maskValue = maskColor.a;\n  }\n\n  if (mask_inverted) {\n    return maskValue >= 0.5;\n  } else {\n    return maskValue < 0.5;\n  }\n}\n";
const inject = {
  'vs:#decl': "\nvarying vec2 mask_texCoords;\n",
  'vs:#main-end': "\n   vec4 mask_common_position;\n   if (mask_maskByInstance) {\n     mask_common_position = project_position(vec4(geometry.worldPosition, 1.0));\n   } else {\n     mask_common_position = geometry.position;\n   }\n   mask_texCoords = mask_getCoords(mask_common_position);\n",
  'fs:#decl': "\nvarying vec2 mask_texCoords;\n",
  'fs:#main-start': "\n  if (mask_enabled) {\n    bool mask = mask_isInBounds(mask_texCoords);\n\n    // Debug: show extent of render target\n    // gl_FragColor = vec4(mask_texCoords, 0.0, 1.0);\n    gl_FragColor = texture2D(mask_texture, mask_texCoords);\n\n    if (!mask) discard;\n  }\n"
};

const getMaskUniforms = opts => {
  if (opts && 'maskMap' in opts) {
    return {
      mask_texture: opts.maskMap
    };
  }

  return {};
};

export default {
  name: 'mask',
  dependencies: [project],
  vs,
  fs,
  inject,
  getUniforms: getMaskUniforms
};
//# sourceMappingURL=shader-module.js.map