import _defineProperty from "@babel/runtime/helpers/esm/defineProperty";
import { LayerExtension, _mergeShaders as mergeShaders } from '@deck.gl/core';
import { dashShaders, offsetShaders } from './shaders.glsl';
import { dist } from 'gl-matrix/vec3';
const defaultProps = {
  getDashArray: {
    type: 'accessor',
    value: [0, 0]
  },
  getOffset: {
    type: 'accessor',
    value: 0
  },
  dashJustified: false,
  dashGapPickable: false
};
export default class PathStyleExtension extends LayerExtension {
  constructor({
    dash = false,
    offset = false,
    highPrecisionDash = false
  } = {}) {
    super({
      dash: dash || highPrecisionDash,
      offset,
      highPrecisionDash
    });
  }

  isEnabled(layer) {
    return 'pathTesselator' in layer.state;
  }

  getShaders(extension) {
    if (!extension.isEnabled(this)) {
      return null;
    }

    let result = {};

    if (extension.opts.dash) {
      result = mergeShaders(result, dashShaders);
    }

    if (extension.opts.offset) {
      result = mergeShaders(result, offsetShaders);
    }

    return result;
  }

  initializeState(context, extension) {
    const attributeManager = this.getAttributeManager();

    if (!attributeManager || !extension.isEnabled(this)) {
      return;
    }

    if (extension.opts.dash) {
      attributeManager.addInstanced({
        instanceDashArrays: {
          size: 2,
          accessor: 'getDashArray'
        }
      });
    }

    if (extension.opts.highPrecisionDash) {
      attributeManager.addInstanced({
        instanceDashOffsets: {
          size: 1,
          accessor: 'getPath',
          transform: extension.getDashOffsets.bind(this)
        }
      });
    }

    if (extension.opts.offset) {
      attributeManager.addInstanced({
        instanceOffsets: {
          size: 1,
          accessor: 'getOffset'
        }
      });
    }
  }

  updateState(params, extension) {
    if (!extension.isEnabled(this)) {
      return;
    }

    const uniforms = {};

    if (extension.opts.dash) {
      uniforms.dashAlignMode = this.props.dashJustified ? 1 : 0;
      uniforms.dashGapPickable = Boolean(this.props.dashGapPickable);
    }

    this.state.model.setUniforms(uniforms);
  }

  getDashOffsets(path) {
    const result = [0];
    const positionSize = this.props.positionFormat === 'XY' ? 2 : 3;
    const isNested = Array.isArray(path[0]);
    const geometrySize = isNested ? path.length : path.length / positionSize;
    let p;
    let prevP;

    for (let i = 0; i < geometrySize - 1; i++) {
      p = isNested ? path[i] : path.slice(i * positionSize, i * positionSize + positionSize);
      p = this.projectPosition(p);

      if (i > 0) {
        result[i] = result[i - 1] + dist(prevP, p);
      }

      prevP = p;
    }

    return result;
  }

}

_defineProperty(PathStyleExtension, "defaultProps", defaultProps);

_defineProperty(PathStyleExtension, "extensionName", 'PathStyleExtension');
//# sourceMappingURL=path-style-extension.js.map