export const dashShaders = {
  inject: {
    'vs:#decl': "\nattribute vec2 instanceDashArrays;\nattribute float instanceDashOffsets;\nvarying vec2 vDashArray;\nvarying float vDashOffset;\n",
    'vs:#main-end': "\nvDashArray = instanceDashArrays;\nvDashOffset = instanceDashOffsets / width.x;\n",
    'fs:#decl': "\nuniform float dashAlignMode;\nuniform float capType;\nuniform bool dashGapPickable;\nvarying vec2 vDashArray;\nvarying float vDashOffset;\n\nfloat round(float x) {\n  return floor(x + 0.5);\n}\n",
    'fs:#main-start': "\n  float solidLength = vDashArray.x;\n  float gapLength = vDashArray.y;\n  float unitLength = solidLength + gapLength;\n\n  float offset;\n\n  if (unitLength > 0.0) {\n    if (dashAlignMode == 0.0) {\n      offset = vDashOffset;\n    } else {\n      unitLength = vPathLength / round(vPathLength / unitLength);\n      offset = solidLength / 2.0;\n    }\n\n    float unitOffset = mod(vPathPosition.y + offset, unitLength);\n\n    if (gapLength > 0.0 && unitOffset > solidLength) {\n      if (capType <= 0.5) {\n        if (!(dashGapPickable && picking_uActive)) {\n          discard;\n        }\n      } else {\n        float distToEnd = length(vec2(\n          min(unitOffset - solidLength, unitLength - unitOffset),\n          vPathPosition.x\n        ));\n        if (distToEnd > 1.0) {\n          if (!(dashGapPickable && picking_uActive)) {\n            discard;\n          }\n        }\n      }\n    }\n  }\n"
  }
};
export const offsetShaders = {
  inject: {
    'vs:#decl': "\nattribute float instanceOffsets;\n",
    'vs:DECKGL_FILTER_SIZE': "\n  float offsetWidth = abs(instanceOffsets * 2.0) + 1.0;\n  size *= offsetWidth;\n",
    'vs:#main-end': "\n  float offsetWidth = abs(instanceOffsets * 2.0) + 1.0;\n  float offsetDir = sign(instanceOffsets);\n  vPathPosition.x = (vPathPosition.x + offsetDir) * offsetWidth - offsetDir;\n  vPathPosition.y *= offsetWidth;\n  vPathLength *= offsetWidth;\n",
    'fs:#main-start': "\n  float isInside;\n  isInside = step(-1.0, vPathPosition.x) * step(vPathPosition.x, 1.0);\n  if (isInside == 0.0) {\n    discard;\n  }\n"
  }
};
//# sourceMappingURL=shaders.glsl.js.map