import _defineProperty from "@babel/runtime/helpers/esm/defineProperty";
import { Framebuffer } from '@luma.gl/core';
import { joinLayerBounds, getRenderBounds, makeViewport } from '../utils/projection-utils';
import { createRenderTarget } from './utils';
const MAP_MAX_SIZE = 2048;
export class HeightMapBuilder {
  static isSupported(gl) {
    return Framebuffer.isSupported(gl, {
      colorBufferFloat: true
    });
  }

  constructor(gl) {
    _defineProperty(this, "renderViewport", null);

    _defineProperty(this, "bounds", null);

    _defineProperty(this, "fbo", void 0);

    _defineProperty(this, "gl", void 0);

    _defineProperty(this, "layers", []);

    _defineProperty(this, "layersBounds", []);

    _defineProperty(this, "layersBoundsCommon", null);

    _defineProperty(this, "lastViewport", null);

    this.gl = gl;
  }

  getRenderFramebuffer() {
    if (!this.renderViewport) {
      return null;
    }

    if (!this.fbo) {
      this.fbo = createRenderTarget(this.gl, {
        id: 'height-map',
        float: true
      });
    }

    return this.fbo;
  }

  shouldUpdate({
    layers,
    viewport
  }) {
    const layersChanged = layers.length !== this.layers.length || layers.some((layer, i) => layer !== this.layers[i] || layer.props.transitions || layer.getBounds() !== this.layersBounds[i]);

    if (layersChanged) {
      this.layers = layers;
      this.layersBounds = layers.map(layer => layer.getBounds());
      this.layersBoundsCommon = joinLayerBounds(layers, viewport);
    }

    const viewportChanged = !this.lastViewport || !viewport.equals(this.lastViewport);

    if (!this.layersBoundsCommon) {
      this.renderViewport = null;
    } else if (layersChanged || viewportChanged) {
      const bounds = getRenderBounds(this.layersBoundsCommon, viewport);

      if (bounds[2] <= bounds[0] || bounds[3] <= bounds[1]) {
        this.renderViewport = null;
        return false;
      }

      this.bounds = bounds;
      this.lastViewport = viewport;
      const scale = viewport.scale;
      const pixelWidth = (bounds[2] - bounds[0]) * scale;
      const pixelHeight = (bounds[3] - bounds[1]) * scale;
      this.renderViewport = pixelWidth > 0 || pixelHeight > 0 ? makeViewport({
        bounds: [viewport.center[0] - 1, viewport.center[1] - 1, viewport.center[0] + 1, viewport.center[1] + 1],
        zoom: viewport.zoom,
        width: Math.min(pixelWidth, MAP_MAX_SIZE),
        height: Math.min(pixelHeight, MAP_MAX_SIZE),
        viewport
      }) : null;
      return true;
    }

    return false;
  }

  delete() {
    if (this.fbo) {
      this.fbo.color.delete();
      this.fbo.delete();
    }
  }

}
//# sourceMappingURL=height-map-builder.js.map