import { project } from '@deck.gl/core';
export const TERRAIN_MODE = {
  NONE: 0,
  WRITE_HEIGHT_MAP: 1,
  USE_HEIGHT_MAP: 2,
  USE_COVER: 3,
  USE_COVER_ONLY: 4,
  SKIP: 5
};
const TERRAIN_MODE_CONSTANTS = Object.keys(TERRAIN_MODE).map(key => "const float TERRAIN_MODE_".concat(key, " = ").concat(TERRAIN_MODE[key], ".0;")).join('\n');
export const terrainModule = {
  name: 'terrain',
  dependencies: [project],
  inject: {
    'vs:#decl': "\nuniform float terrain_mode;\nuniform sampler2D terrain_map;\nuniform vec4 terrain_bounds;\nvarying vec3 commonPos;\n".concat(TERRAIN_MODE_CONSTANTS, "\n    "),
    'vs:#main-start': "\nif (terrain_mode == TERRAIN_MODE_SKIP) {\n  gl_Position = vec4(0.0);\n  return;\n}\n",
    'vs:DECKGL_FILTER_GL_POSITION': "\ncommonPos = geometry.position.xyz;\nif (terrain_mode == TERRAIN_MODE_WRITE_HEIGHT_MAP) {\n  vec2 texCoords = (commonPos.xy - terrain_bounds.xy) / terrain_bounds.zw;\n  position = vec4(texCoords * 2.0 - 1.0, 0.0, 1.0);\n  commonPos.z += project_uCommonOrigin.z;\n}\nif (terrain_mode == TERRAIN_MODE_USE_HEIGHT_MAP) {\n  vec3 anchor = geometry.worldPosition;\n  anchor.z = 0.0;\n  vec3 anchorCommon = project_position(anchor);\n  vec2 texCoords = (anchorCommon.xy - terrain_bounds.xy) / terrain_bounds.zw;\n  if (texCoords.x >= 0.0 && texCoords.y >= 0.0 && texCoords.x <= 1.0 && texCoords.y <= 1.0) {\n    float terrainZ = texture2D(terrain_map, texCoords).r;\n    geometry.position.z += terrainZ;\n    position = project_common_position_to_clipspace(geometry.position);\n  }\n}\n    ",
    'fs:#decl': "\nuniform float terrain_mode;\nuniform sampler2D terrain_map;\nuniform vec4 terrain_bounds;\nvarying vec3 commonPos;\n".concat(TERRAIN_MODE_CONSTANTS, "\n    "),
    'fs:#main-start': "\nif (terrain_mode == TERRAIN_MODE_WRITE_HEIGHT_MAP) {\n  gl_FragColor = vec4(commonPos.z, 0.0, 0.0, 1.0);\n  return;\n}\n    ",
    'fs:DECKGL_FILTER_COLOR': "\nif ((terrain_mode == TERRAIN_MODE_USE_COVER) || (terrain_mode == TERRAIN_MODE_USE_COVER_ONLY)) {\n  vec2 texCoords = (commonPos.xy - terrain_bounds.xy) / terrain_bounds.zw;\n  vec4 pixel = texture2D(terrain_map, texCoords);\n  if (terrain_mode == TERRAIN_MODE_USE_COVER_ONLY) {\n    color = pixel;\n  } else {\n    // pixel is premultiplied\n    color = pixel + color * (1.0 - pixel.a);\n  }\n  return;\n}\n    "
  },
  getUniforms: (opts = {}, uniforms) => {
    if ('dummyHeightMap' in opts) {
      const {
        drawToTerrainHeightMap,
        heightMap,
        heightMapBounds,
        dummyHeightMap,
        terrainCover,
        useTerrainHeightMap,
        terrainSkipRender
      } = opts;
      const {
        project_uCommonOrigin
      } = uniforms;
      let mode = terrainSkipRender ? TERRAIN_MODE.SKIP : TERRAIN_MODE.NONE;
      let sampler = dummyHeightMap;
      let bounds = null;

      if (drawToTerrainHeightMap) {
        mode = TERRAIN_MODE.WRITE_HEIGHT_MAP;
        bounds = heightMapBounds;
      } else if (useTerrainHeightMap && heightMap) {
        mode = TERRAIN_MODE.USE_HEIGHT_MAP;
        sampler = heightMap;
        bounds = heightMapBounds;
      } else if (terrainCover) {
        const isPicking = opts.pickingActive;
        sampler = isPicking ? terrainCover.getPickingFramebuffer() : terrainCover.getRenderFramebuffer();

        if (isPicking) {
          mode = TERRAIN_MODE.SKIP;
        }

        if (sampler) {
          mode = mode === TERRAIN_MODE.SKIP ? TERRAIN_MODE.USE_COVER_ONLY : TERRAIN_MODE.USE_COVER;
          bounds = terrainCover.bounds;
        } else {
          sampler = dummyHeightMap;
        }
      }

      return {
        terrain_mode: mode,
        terrain_map: sampler,
        terrain_bounds: bounds ? [bounds[0] - project_uCommonOrigin[0], bounds[1] - project_uCommonOrigin[1], bounds[2] - bounds[0], bounds[3] - bounds[1]] : [0, 0, 0, 0]
      };
    }

    return null;
  }
};
//# sourceMappingURL=shader-module.js.map