import _defineProperty from "@babel/runtime/helpers/esm/defineProperty";
import { LayerExtension } from '@deck.gl/core';
import { TerrainEffect } from './terrain-effect';
import { terrainModule } from './shader-module';
const defaultProps = {
  terrainDrawMode: undefined
};
export default class TerrainExtension extends LayerExtension {
  getShaders() {
    return {
      modules: [terrainModule]
    };
  }

  initializeState() {
    var _this$context$deck;

    (_this$context$deck = this.context.deck) === null || _this$context$deck === void 0 ? void 0 : _this$context$deck._addDefaultEffect(new TerrainEffect());
  }

  updateState(params) {
    const {
      props,
      oldProps
    } = params;

    if (this.state.terrainDrawMode && props.terrainDrawMode === oldProps.terrainDrawMode && props.extruded === oldProps.extruded) {
      return;
    }

    let {
      terrainDrawMode
    } = props;

    if (!terrainDrawMode) {
      var _this$getAttributeMan;

      const is3d = this.props.extruded;
      const attributes = (_this$getAttributeMan = this.getAttributeManager()) === null || _this$getAttributeMan === void 0 ? void 0 : _this$getAttributeMan.attributes;
      const hasAnchor = attributes && 'instancePositions' in attributes;
      terrainDrawMode = is3d || hasAnchor ? 'offset' : 'drape';
    }

    this.setState({
      terrainDrawMode
    });
  }

  onNeedsRedraw() {
    const state = this.state;

    if (state.terrainDrawMode === 'drape') {
      state.terrainCoverNeedsRedraw = true;
    }
  }

}

_defineProperty(TerrainExtension, "defaultProps", defaultProps);

_defineProperty(TerrainExtension, "extensionName", 'TerrainExtension');
//# sourceMappingURL=terrain-extension.js.map