import { withParameters } from '@luma.gl/core';
import { _LayersPass as LayersPass } from '@deck.gl/core';
export class TerrainPass extends LayersPass {
  getRenderableLayers(viewport, opts) {
    const {
      layers
    } = opts;
    const result = [];

    const drawParamsByIndex = this._getDrawLayerParams(viewport, opts, true);

    for (let i = 0; i < layers.length; i++) {
      const layer = layers[i];

      if (!layer.isComposite && drawParamsByIndex[i].shouldDrawLayer) {
        result.push(layer);
      }
    }

    return result;
  }

  renderHeightMap(heightMap, opts) {
    const target = heightMap.getRenderFramebuffer();
    const viewport = heightMap.renderViewport;

    if (!target || !viewport) {
      return;
    }

    target.resize(viewport);
    withParameters(this.gl, {
      clearColor: [0, 0, 0, 0],
      blend: true,
      blendFunc: [1, 1],
      blendEquation: 32776,
      depthTest: false
    }, () => this.render({ ...opts,
      target,
      pass: 'terrain-height-map',
      layers: opts.layers,
      viewports: [viewport],
      effects: []
    }));
  }

  renderTerrainCover(terrainCover, opts) {
    const target = terrainCover.getRenderFramebuffer();
    const viewport = terrainCover.renderViewport;

    if (!target || !viewport) {
      return;
    }

    const layers = terrainCover.filterLayers(opts.layers);
    target.resize(viewport);
    withParameters(this.gl, {
      clearColor: [0, 0, 0, 0],
      depthTest: false
    }, () => this.render({ ...opts,
      target,
      pass: "terrain-cover-".concat(terrainCover.id),
      layers,
      effects: [],
      viewports: [viewport]
    }));
  }

}
//# sourceMappingURL=terrain-pass.js.map