import _defineProperty from "@babel/runtime/helpers/esm/defineProperty";
import { _PickLayersPass as PickLayersPass } from '@deck.gl/core';
import { withParameters } from '@luma.gl/core';
export class TerrainPickingPass extends PickLayersPass {
  constructor(...args) {
    super(...args);

    _defineProperty(this, "drawParameters", {});
  }

  getRenderableLayers(viewport, opts) {
    const {
      layers
    } = opts;
    const result = [];
    this.drawParameters = {};

    this._resetColorEncoder(opts.pickZ);

    const drawParamsByIndex = this._getDrawLayerParams(viewport, opts);

    for (let i = 0; i < layers.length; i++) {
      const layer = layers[i];

      if (!layer.isComposite && drawParamsByIndex[i].shouldDrawLayer) {
        result.push(layer);
        this.drawParameters[layer.id] = drawParamsByIndex[i].layerParameters;
      }
    }

    return result;
  }

  renderTerrainCover(terrainCover, opts) {
    const target = terrainCover.getPickingFramebuffer();
    const viewport = terrainCover.renderViewport;

    if (!target || !viewport) {
      return;
    }

    const layers = terrainCover.filterLayers(opts.layers);
    const terrainLayer = terrainCover.targetLayer;

    if (terrainLayer.props.pickable) {
      layers.unshift(terrainLayer);
    }

    target.resize(viewport);
    withParameters(this.gl, {
      depthTest: false
    }, () => this.render({ ...opts,
      pickingFBO: target,
      pass: "terrain-cover-picking-".concat(terrainCover.id),
      layers,
      effects: [],
      viewports: [viewport],
      cullRect: undefined,
      deviceRect: viewport,
      pickZ: false
    }));
  }

  getLayerParameters(layer, layerIndex, viewport) {
    if (this.drawParameters[layer.id]) {
      return this.drawParameters[layer.id];
    }

    const parameters = super.getLayerParameters(layer, layerIndex, viewport);
    parameters.blend = true;
    return parameters;
  }

}
//# sourceMappingURL=terrain-picking-pass.js.map