"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _h3Js = require("h3-js");

var _core = require("@deck.gl/core");

var _h3HexagonLayer = _interopRequireDefault(require("./h3-hexagon-layer"));

var _GeoCellLayer2 = _interopRequireDefault(require("../geo-cell-layer/GeoCellLayer"));

function _createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it.return != null) it.return(); } finally { if (didErr) throw err; } } }; }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

var defaultProps = {
  getHexagons: {
    type: 'accessor',
    value: function value(d) {
      return d.hexagons;
    }
  }
};

var H3ClusterLayer = function (_GeoCellLayer) {
  (0, _inherits2.default)(H3ClusterLayer, _GeoCellLayer);

  var _super = _createSuper(H3ClusterLayer);

  function H3ClusterLayer() {
    (0, _classCallCheck2.default)(this, H3ClusterLayer);
    return _super.apply(this, arguments);
  }

  (0, _createClass2.default)(H3ClusterLayer, [{
    key: "initializeState",
    value: function initializeState() {
      _h3HexagonLayer.default._checkH3Lib();
    }
  }, {
    key: "updateState",
    value: function updateState(_ref) {
      var props = _ref.props,
          changeFlags = _ref.changeFlags;

      if (changeFlags.dataChanged || changeFlags.updateTriggersChanged && changeFlags.updateTriggersChanged.getHexagons) {
        var data = props.data,
            getHexagons = props.getHexagons;
        var polygons = [];

        var _createIterable = (0, _core.createIterable)(data),
            iterable = _createIterable.iterable,
            objectInfo = _createIterable.objectInfo;

        var _iterator = _createForOfIteratorHelper(iterable),
            _step;

        try {
          for (_iterator.s(); !(_step = _iterator.n()).done;) {
            var object = _step.value;
            objectInfo.index++;
            var hexagons = getHexagons(object, objectInfo);
            var multiPolygon = (0, _h3Js.h3SetToMultiPolygon)(hexagons, true);

            var _iterator2 = _createForOfIteratorHelper(multiPolygon),
                _step2;

            try {
              for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
                var polygon = _step2.value;
                polygons.push(this.getSubLayerRow({
                  polygon: polygon
                }, object, objectInfo.index));
              }
            } catch (err) {
              _iterator2.e(err);
            } finally {
              _iterator2.f();
            }
          }
        } catch (err) {
          _iterator.e(err);
        } finally {
          _iterator.f();
        }

        this.setState({
          polygons: polygons
        });
      }
    }
  }, {
    key: "indexToBounds",
    value: function indexToBounds() {
      var _this$props = this.props,
          getElevation = _this$props.getElevation,
          getFillColor = _this$props.getFillColor,
          getLineColor = _this$props.getLineColor,
          getLineWidth = _this$props.getLineWidth;
      return {
        data: this.state.polygons,
        getPolygon: function getPolygon(d) {
          return d.polygon;
        },
        getElevation: this.getSubLayerAccessor(getElevation),
        getFillColor: this.getSubLayerAccessor(getFillColor),
        getLineColor: this.getSubLayerAccessor(getLineColor),
        getLineWidth: this.getSubLayerAccessor(getLineWidth)
      };
    }
  }]);
  return H3ClusterLayer;
}(_GeoCellLayer2.default);

exports.default = H3ClusterLayer;
(0, _defineProperty2.default)(H3ClusterLayer, "layerName", 'H3ClusterLayer');
(0, _defineProperty2.default)(H3ClusterLayer, "defaultProps", defaultProps);
//# sourceMappingURL=h3-cluster-layer.js.map