"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _default = "#version 300 es\n#define SHADER_NAME simple-mesh-layer-vs\nuniform float sizeScale;\nuniform bool composeModelMatrix;\nuniform bool pickFeatureIds;\nin vec3 positions;\nin vec3 normals;\nin vec3 colors;\nin vec2 texCoords;\nin vec4 uvRegions;\nin vec3 featureIdsPickingColors;\nin vec4 instanceColors;\nin vec3 instancePickingColors;\nin mat3 instanceModelMatrix;\nout vec2 vTexCoord;\nout vec3 cameraPosition;\nout vec3 normals_commonspace;\nout vec4 position_commonspace;\nout vec4 vColor;\n\nvec2 applyUVRegion(vec2 uv) {\n  #ifdef HAS_UV_REGIONS\n    return fract(uv) * (uvRegions.zw - uvRegions.xy) + uvRegions.xy;\n  #else\n    return uv;\n  #endif\n}\n\nvoid main(void) {\n  vec2 uv = applyUVRegion(texCoords);\n  geometry.uv = uv;\n\n  if (pickFeatureIds) {\n    geometry.pickingColor = featureIdsPickingColors;\n  } else {\n    geometry.pickingColor = instancePickingColors;\n  }\n\n  vTexCoord = uv;\n  cameraPosition = project_uCameraPosition;\n  vColor = vec4(colors * instanceColors.rgb, instanceColors.a);\n\n  vec3 pos = (instanceModelMatrix * positions) * sizeScale;\n  vec3 projectedPosition = project_position(positions);\n  position_commonspace = vec4(projectedPosition, 1.0);\n  gl_Position = project_common_position_to_clipspace(position_commonspace);\n\n  geometry.position = position_commonspace;\n  normals_commonspace = project_normal(instanceModelMatrix * normals);\n  geometry.normal = normals_commonspace;\n\n  DECKGL_FILTER_GL_POSITION(gl_Position, geometry);\n\n  #ifdef MODULE_PBR\n    pbr_vPosition = geometry.position.xyz;\n    #ifdef HAS_NORMALS\n      pbr_vNormal = geometry.normal;\n    #endif\n\n    #ifdef HAS_UV\n      pbr_vUV = uv;\n    #else\n      pbr_vUV = vec2(0., 0.);\n    #endif\n    geometry.uv = pbr_vUV;\n  #endif\n\n  DECKGL_FILTER_COLOR(vColor, geometry);\n}\n";
exports.default = _default;
//# sourceMappingURL=mesh-layer-vertex.glsl.js.map