"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.transform = transform;

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));

var _core = require("@math.gl/core");

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { (0, _defineProperty2.default)(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

var availableTransformations = {
  Point: Point,
  MultiPoint: MultiPoint,
  LineString: LineString,
  MultiLineString: MultiLineString,
  Polygon: Polygon,
  MultiPolygon: MultiPolygon
};

function Point(_ref, _ref2, viewport) {
  var _ref3 = (0, _slicedToArray2.default)(_ref, 2),
      pointX = _ref3[0],
      pointY = _ref3[1];

  var _ref4 = (0, _slicedToArray2.default)(_ref2, 2),
      nw = _ref4[0],
      se = _ref4[1];

  var x = (0, _core.lerp)(nw[0], se[0], pointX);
  var y = (0, _core.lerp)(nw[1], se[1], pointY);
  return viewport.unprojectFlat([x, y]);
}

function getPoints(geometry, bbox, viewport) {
  return geometry.map(function (g) {
    return Point(g, bbox, viewport);
  });
}

function MultiPoint(multiPoint, bbox, viewport) {
  return getPoints(multiPoint, bbox, viewport);
}

function LineString(line, bbox, viewport) {
  return getPoints(line, bbox, viewport);
}

function MultiLineString(multiLineString, bbox, viewport) {
  return multiLineString.map(function (lineString) {
    return LineString(lineString, bbox, viewport);
  });
}

function Polygon(polygon, bbox, viewport) {
  return polygon.map(function (polygonRing) {
    return getPoints(polygonRing, bbox, viewport);
  });
}

function MultiPolygon(multiPolygon, bbox, viewport) {
  return multiPolygon.map(function (polygon) {
    return Polygon(polygon, bbox, viewport);
  });
}

function transform(geometry, bbox, viewport) {
  var nw = viewport.projectFlat([bbox.west, bbox.north]);
  var se = viewport.projectFlat([bbox.east, bbox.south]);
  var projectedBbox = [nw, se];
  return _objectSpread(_objectSpread({}, geometry), {}, {
    coordinates: availableTransformations[geometry.type](geometry.coordinates, projectedBbox, viewport)
  });
}
//# sourceMappingURL=coordinate-transform.js.map