"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.quadkeyToWorldBounds = quadkeyToWorldBounds;
exports.getQuadkeyPolygon = getQuadkeyPolygon;

var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));

var _webMercator = require("@math.gl/web-mercator");

var TILE_SIZE = 512;

function quadkeyToWorldBounds(quadkey, coverage) {
  var x = 0;
  var y = 0;
  var mask = 1 << quadkey.length;
  var scale = mask / TILE_SIZE;

  for (var i = 0; i < quadkey.length; i++) {
    mask >>= 1;
    var q = parseInt(quadkey[i]);
    if (q % 2) x |= mask;
    if (q > 1) y |= mask;
  }

  return [[x / scale, TILE_SIZE - y / scale], [(x + coverage) / scale, TILE_SIZE - (y + coverage) / scale]];
}

function getQuadkeyPolygon(quadkey) {
  var coverage = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 1;

  var _quadkeyToWorldBounds = quadkeyToWorldBounds(quadkey, coverage),
      _quadkeyToWorldBounds2 = (0, _slicedToArray2.default)(_quadkeyToWorldBounds, 2),
      topLeft = _quadkeyToWorldBounds2[0],
      bottomRight = _quadkeyToWorldBounds2[1];

  var _worldToLngLat = (0, _webMercator.worldToLngLat)(topLeft),
      _worldToLngLat2 = (0, _slicedToArray2.default)(_worldToLngLat, 2),
      w = _worldToLngLat2[0],
      n = _worldToLngLat2[1];

  var _worldToLngLat3 = (0, _webMercator.worldToLngLat)(bottomRight),
      _worldToLngLat4 = (0, _slicedToArray2.default)(_worldToLngLat3, 2),
      e = _worldToLngLat4[0],
      s = _worldToLngLat4[1];

  return [e, n, e, s, w, s, w, n, e, n];
}
//# sourceMappingURL=quadkey-utils.js.map