"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _get2 = _interopRequireDefault(require("@babel/runtime/helpers/get"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _layers = require("@deck.gl/layers");

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { (0, _defineProperty2.default)(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

var defaultProps = {
  fadeTrail: true,
  trailLength: {
    type: 'number',
    value: 120,
    min: 0
  },
  currentTime: {
    type: 'number',
    value: 0,
    min: 0
  },
  getTimestamps: {
    type: 'accessor',
    value: function value(d) {
      return d.timestamps;
    }
  }
};

var TripsLayer = function (_PathLayer) {
  (0, _inherits2.default)(TripsLayer, _PathLayer);

  var _super = _createSuper(TripsLayer);

  function TripsLayer() {
    (0, _classCallCheck2.default)(this, TripsLayer);
    return _super.apply(this, arguments);
  }

  (0, _createClass2.default)(TripsLayer, [{
    key: "getShaders",
    value: function getShaders() {
      var shaders = (0, _get2.default)((0, _getPrototypeOf2.default)(TripsLayer.prototype), "getShaders", this).call(this);
      shaders.inject = {
        'vs:#decl': "uniform float trailLength;\nattribute float instanceTimestamps;\nattribute float instanceNextTimestamps;\nvarying float vTime;\n",
        'vs:#main-end': "vTime = instanceTimestamps + (instanceNextTimestamps - instanceTimestamps) * vPathPosition.y / vPathLength;\n",
        'fs:#decl': "uniform bool fadeTrail;\nuniform float trailLength;\nuniform float currentTime;\nvarying float vTime;\n",
        'fs:#main-start': "if(vTime > currentTime || (fadeTrail && (vTime < currentTime - trailLength))) {\n  discard;\n}\n",
        'fs:DECKGL_FILTER_COLOR': "if(fadeTrail) {\n  color.a *= 1.0 - (currentTime - vTime) / trailLength;\n}\n"
      };
      return shaders;
    }
  }, {
    key: "initializeState",
    value: function initializeState() {
      (0, _get2.default)((0, _getPrototypeOf2.default)(TripsLayer.prototype), "initializeState", this).call(this);
      var attributeManager = this.getAttributeManager();
      attributeManager.addInstanced({
        timestamps: {
          size: 1,
          accessor: 'getTimestamps',
          shaderAttributes: {
            instanceTimestamps: {
              vertexOffset: 0
            },
            instanceNextTimestamps: {
              vertexOffset: 1
            }
          }
        }
      });
    }
  }, {
    key: "draw",
    value: function draw(params) {
      var _this$props = this.props,
          fadeTrail = _this$props.fadeTrail,
          trailLength = _this$props.trailLength,
          currentTime = _this$props.currentTime;
      params.uniforms = _objectSpread(_objectSpread({}, params.uniforms), {}, {
        fadeTrail: fadeTrail,
        trailLength: trailLength,
        currentTime: currentTime
      });
      (0, _get2.default)((0, _getPrototypeOf2.default)(TripsLayer.prototype), "draw", this).call(this, params);
    }
  }]);
  return TripsLayer;
}(_layers.PathLayer);

exports.default = TripsLayer;
(0, _defineProperty2.default)(TripsLayer, "layerName", 'TripsLayer');
(0, _defineProperty2.default)(TripsLayer, "defaultProps", defaultProps);
//# sourceMappingURL=trips-layer.js.map