"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WGS84ToPseudoMercator = WGS84ToPseudoMercator;

var _webMercator = require("@math.gl/web-mercator");

var HALF_EARTH_CIRCUMFERENCE = 6378137 * Math.PI;

function WGS84ToPseudoMercator(coord) {
  var mercator = (0, _webMercator.lngLatToWorld)(coord);
  mercator[0] = (mercator[0] / 256 - 1) * HALF_EARTH_CIRCUMFERENCE;
  mercator[1] = (mercator[1] / 256 - 1) * HALF_EARTH_CIRCUMFERENCE;
  return mercator;
}
//# sourceMappingURL=utils.js.map