import _defineProperty from "@babel/runtime/helpers/esm/defineProperty";
import { CompositeLayer } from '@deck.gl/core';
import { PolygonLayer } from '@deck.gl/layers';
const defaultProps = { ...PolygonLayer.defaultProps
};
export default class GeoCellLayer extends CompositeLayer {
  indexToBounds() {
    return null;
  }

  renderLayers() {
    const {
      elevationScale,
      extruded,
      wireframe,
      filled,
      stroked,
      lineWidthUnits,
      lineWidthScale,
      lineWidthMinPixels,
      lineWidthMaxPixels,
      lineJointRounded,
      lineMiterLimit,
      lineDashJustified,
      getElevation,
      getFillColor,
      getLineColor,
      getLineWidth
    } = this.props;
    const {
      updateTriggers,
      material,
      transitions
    } = this.props;
    const CellLayer = this.getSubLayerClass('cell', PolygonLayer);
    const {
      updateTriggers: boundsUpdateTriggers,
      ...boundsProps
    } = this.indexToBounds() || {};
    return new CellLayer({
      filled,
      wireframe,
      extruded,
      elevationScale,
      stroked,
      lineWidthUnits,
      lineWidthScale,
      lineWidthMinPixels,
      lineWidthMaxPixels,
      lineJointRounded,
      lineMiterLimit,
      lineDashJustified,
      material,
      transitions,
      getElevation,
      getFillColor,
      getLineColor,
      getLineWidth
    }, this.getSubLayerProps({
      id: 'cell',
      updateTriggers: updateTriggers && { ...boundsUpdateTriggers,
        getElevation: updateTriggers.getElevation,
        getFillColor: updateTriggers.getFillColor,
        getLineColor: updateTriggers.getLineColor,
        getLineWidth: updateTriggers.getLineWidth
      }
    }), boundsProps);
  }

}

_defineProperty(GeoCellLayer, "layerName", 'GeoCellLayer');

_defineProperty(GeoCellLayer, "defaultProps", defaultProps);
//# sourceMappingURL=GeoCellLayer.js.map