import _defineProperty from "@babel/runtime/helpers/esm/defineProperty";
import GeoCellLayer from '../geo-cell-layer/GeoCellLayer';
import { getGeohashPolygon } from './geohash-utils';
const defaultProps = {
  getGeohash: {
    type: 'accessor',
    value: d => d.geohash
  }
};
export default class GeohashLayer extends GeoCellLayer {
  indexToBounds() {
    const {
      data,
      getGeohash
    } = this.props;
    return {
      data,
      _normalize: false,
      positionFormat: 'XY',
      getPolygon: (x, objectInfo) => getGeohashPolygon(getGeohash(x, objectInfo))
    };
  }

}

_defineProperty(GeohashLayer, "layerName", 'GeohashLayer');

_defineProperty(GeohashLayer, "defaultProps", defaultProps);
//# sourceMappingURL=geohash-layer.js.map