import _defineProperty from "@babel/runtime/helpers/esm/defineProperty";
import { h3SetToMultiPolygon } from 'h3-js';
import { createIterable } from '@deck.gl/core';
import { default as H3HexagonLayer } from './h3-hexagon-layer';
import GeoCellLayer from '../geo-cell-layer/GeoCellLayer';
const defaultProps = {
  getHexagons: {
    type: 'accessor',
    value: d => d.hexagons
  }
};
export default class H3ClusterLayer extends GeoCellLayer {
  initializeState() {
    H3HexagonLayer._checkH3Lib();
  }

  updateState({
    props,
    changeFlags
  }) {
    if (changeFlags.dataChanged || changeFlags.updateTriggersChanged && changeFlags.updateTriggersChanged.getHexagons) {
      const {
        data,
        getHexagons
      } = props;
      const polygons = [];
      const {
        iterable,
        objectInfo
      } = createIterable(data);

      for (const object of iterable) {
        objectInfo.index++;
        const hexagons = getHexagons(object, objectInfo);
        const multiPolygon = h3SetToMultiPolygon(hexagons, true);

        for (const polygon of multiPolygon) {
          polygons.push(this.getSubLayerRow({
            polygon
          }, object, objectInfo.index));
        }
      }

      this.setState({
        polygons
      });
    }
  }

  indexToBounds() {
    const {
      getElevation,
      getFillColor,
      getLineColor,
      getLineWidth
    } = this.props;
    return {
      data: this.state.polygons,
      getPolygon: d => d.polygon,
      getElevation: this.getSubLayerAccessor(getElevation),
      getFillColor: this.getSubLayerAccessor(getFillColor),
      getLineColor: this.getSubLayerAccessor(getLineColor),
      getLineWidth: this.getSubLayerAccessor(getLineWidth)
    };
  }

}

_defineProperty(H3ClusterLayer, "layerName", 'H3ClusterLayer');

_defineProperty(H3ClusterLayer, "defaultProps", defaultProps);
//# sourceMappingURL=h3-cluster-layer.js.map