import _defineProperty from "@babel/runtime/helpers/esm/defineProperty";
import GeoCellLayer from '../geo-cell-layer/GeoCellLayer';
import { getQuadkeyPolygon } from './quadkey-utils';
const defaultProps = {
  getQuadkey: {
    type: 'accessor',
    value: d => d.quadkey
  }
};
export default class QuadkeyLayer extends GeoCellLayer {
  indexToBounds() {
    const {
      data,
      extruded,
      getQuadkey
    } = this.props;
    const coverage = extruded ? 0.99 : 1;
    return {
      data,
      _normalize: false,
      positionFormat: 'XY',
      getPolygon: (x, objectInfo) => getQuadkeyPolygon(getQuadkey(x, objectInfo), coverage),
      updateTriggers: {
        getPolygon: coverage
      }
    };
  }

}

_defineProperty(QuadkeyLayer, "layerName", 'QuadkeyLayer');

_defineProperty(QuadkeyLayer, "defaultProps", defaultProps);
//# sourceMappingURL=quadkey-layer.js.map