import _defineProperty from "@babel/runtime/helpers/esm/defineProperty";
import GeoCellLayer from '../geo-cell-layer/GeoCellLayer';
import { getS2Polygon } from './s2-utils';
const defaultProps = {
  getS2Token: {
    type: 'accessor',
    value: d => d.token
  }
};
export default class S2Layer extends GeoCellLayer {
  indexToBounds() {
    const {
      data,
      getS2Token
    } = this.props;
    return {
      data,
      _normalize: false,
      positionFormat: 'XY',
      getPolygon: (x, objectInfo) => getS2Polygon(getS2Token(x, objectInfo))
    };
  }

}

_defineProperty(S2Layer, "layerName", 'S2Layer');

_defineProperty(S2Layer, "defaultProps", defaultProps);
//# sourceMappingURL=s2-layer.js.map