import _defineProperty from "@babel/runtime/helpers/esm/defineProperty";
import { CompositeLayer, _flatten as flatten } from '@deck.gl/core';
import { GeoJsonLayer } from '@deck.gl/layers';
import { Tileset2D, STRATEGY_DEFAULT } from '../tileset-2d';
import { urlType, getURLFromTemplate } from '../tileset-2d';
const defaultProps = {
  TilesetClass: Tileset2D,
  data: {
    type: 'data',
    value: []
  },
  dataComparator: urlType.equal,
  renderSubLayers: {
    type: 'function',
    value: props => new GeoJsonLayer(props)
  },
  getTileData: {
    type: 'function',
    optional: true,
    value: null
  },
  onViewportLoad: {
    type: 'function',
    optional: true,
    value: null
  },
  onTileLoad: {
    type: 'function',
    value: tile => {}
  },
  onTileUnload: {
    type: 'function',
    value: tile => {}
  },
  onTileError: {
    type: 'function',
    value: err => console.error(err)
  },
  extent: {
    type: 'array',
    optional: true,
    value: null,
    compare: true
  },
  tileSize: 512,
  maxZoom: null,
  minZoom: 0,
  maxCacheSize: null,
  maxCacheByteSize: null,
  refinementStrategy: STRATEGY_DEFAULT,
  zRange: null,
  maxRequests: 6,
  zoomOffset: 0
};
export default class TileLayer extends CompositeLayer {
  constructor(...args) {
    super(...args);

    _defineProperty(this, "state", void 0);
  }

  initializeState() {
    this.state = {
      tileset: null,
      isLoaded: false
    };
  }

  finalizeState() {
    var _this$state, _this$state$tileset;

    (_this$state = this.state) === null || _this$state === void 0 ? void 0 : (_this$state$tileset = _this$state.tileset) === null || _this$state$tileset === void 0 ? void 0 : _this$state$tileset.finalize();
  }

  get isLoaded() {
    var _this$state2, _this$state2$tileset, _this$state2$tileset$;

    return Boolean((_this$state2 = this.state) === null || _this$state2 === void 0 ? void 0 : (_this$state2$tileset = _this$state2.tileset) === null || _this$state2$tileset === void 0 ? void 0 : (_this$state2$tileset$ = _this$state2$tileset.selectedTiles) === null || _this$state2$tileset$ === void 0 ? void 0 : _this$state2$tileset$.every(tile => tile.isLoaded && tile.layers && tile.layers.every(layer => layer.isLoaded)));
  }

  shouldUpdateState({
    changeFlags
  }) {
    return changeFlags.somethingChanged;
  }

  updateState({
    changeFlags
  }) {
    let {
      tileset
    } = this.state;
    const propsChanged = changeFlags.propsOrDataChanged || changeFlags.updateTriggersChanged;
    const dataChanged = changeFlags.dataChanged || changeFlags.updateTriggersChanged && (changeFlags.updateTriggersChanged.all || changeFlags.updateTriggersChanged.getTileData);

    if (!tileset) {
      tileset = new this.props.TilesetClass(this._getTilesetOptions());
      this.setState({
        tileset
      });
    } else if (propsChanged) {
      tileset.setOptions(this._getTilesetOptions());

      if (dataChanged) {
        tileset.reloadAll();
      } else {
        tileset.tiles.forEach(tile => {
          tile.layers = null;
        });
      }
    }

    this._updateTileset();
  }

  _getTilesetOptions() {
    const {
      tileSize,
      maxCacheSize,
      maxCacheByteSize,
      refinementStrategy,
      extent,
      maxZoom,
      minZoom,
      maxRequests,
      zoomOffset
    } = this.props;
    return {
      maxCacheSize,
      maxCacheByteSize,
      maxZoom,
      minZoom,
      tileSize,
      refinementStrategy,
      extent,
      maxRequests,
      zoomOffset,
      getTileData: this.getTileData.bind(this),
      onTileLoad: this._onTileLoad.bind(this),
      onTileError: this._onTileError.bind(this),
      onTileUnload: this._onTileUnload.bind(this)
    };
  }

  _updateTileset() {
    const tileset = this.state.tileset;
    const {
      zRange,
      modelMatrix
    } = this.props;
    const frameNumber = tileset.update(this.context.viewport, {
      zRange,
      modelMatrix
    });
    const {
      isLoaded
    } = tileset;
    const loadingStateChanged = this.state.isLoaded !== isLoaded;
    const tilesetChanged = this.state.frameNumber !== frameNumber;

    if (isLoaded && (loadingStateChanged || tilesetChanged)) {
      this._onViewportLoad();
    }

    if (tilesetChanged) {
      this.setState({
        frameNumber
      });
    }

    this.state.isLoaded = isLoaded;
  }

  _onViewportLoad() {
    const {
      tileset
    } = this.state;
    const {
      onViewportLoad
    } = this.props;

    if (onViewportLoad) {
      onViewportLoad(tileset.selectedTiles);
    }
  }

  _onTileLoad(tile) {
    this.props.onTileLoad(tile);
    tile.layers = null;
    this.setNeedsUpdate();
  }

  _onTileError(error, tile) {
    this.props.onTileError(error);
    tile.layers = null;
    this.setNeedsUpdate();
  }

  _onTileUnload(tile) {
    this.props.onTileUnload(tile);
  }

  getTileData(tile) {
    const {
      data,
      getTileData,
      fetch
    } = this.props;
    const {
      signal
    } = tile;
    tile.url = typeof data === 'string' || Array.isArray(data) ? getURLFromTemplate(data, tile) : null;

    if (getTileData) {
      return getTileData(tile);
    }

    if (fetch && tile.url) {
      return fetch(tile.url, {
        propName: 'data',
        layer: this,
        signal
      });
    }

    return null;
  }

  renderSubLayers(props) {
    return this.props.renderSubLayers(props);
  }

  getSubLayerPropsByTile(tile) {
    return null;
  }

  getPickingInfo({
    info,
    sourceLayer
  }) {
    const sourceTile = sourceLayer.props.tile;

    if (info.picked) {
      info.tile = sourceTile;
    }

    info.sourceTile = sourceTile;
    return info;
  }

  _updateAutoHighlight(info) {
    const sourceTile = info.sourceTile;

    if (sourceTile && sourceTile.layers) {
      for (const layer of sourceTile.layers) {
        layer.updateAutoHighlight(info);
      }
    }
  }

  renderLayers() {
    return this.state.tileset.tiles.map(tile => {
      const subLayerProps = this.getSubLayerPropsByTile(tile);

      if (!tile.isLoaded && !tile.content) {} else if (!tile.layers) {
        const layers = this.renderSubLayers({ ...this.props,
          ...this.getSubLayerProps({
            id: tile.id,
            updateTriggers: this.props.updateTriggers
          }),
          data: tile.content,
          _offset: 0,
          tile
        });
        tile.layers = flatten(layers, Boolean).map(layer => layer.clone({
          tile,
          ...subLayerProps
        }));
      } else if (subLayerProps && tile.layers[0] && Object.keys(subLayerProps).some(propName => tile.layers[0].props[propName] !== subLayerProps[propName])) {
        tile.layers = tile.layers.map(layer => layer.clone(subLayerProps));
      }

      return tile.layers;
    });
  }

  filterSubLayer({
    layer,
    cullRect
  }) {
    const {
      tile
    } = layer.props;
    return this.state.tileset.isTileVisible(tile, cullRect);
  }

}

_defineProperty(TileLayer, "defaultProps", defaultProps);

_defineProperty(TileLayer, "layerName", 'TileLayer');
//# sourceMappingURL=tile-layer.js.map