import _defineProperty from "@babel/runtime/helpers/esm/defineProperty";
export class Tile2DHeader {
  constructor(index) {
    _defineProperty(this, "index", void 0);

    _defineProperty(this, "isVisible", void 0);

    _defineProperty(this, "isSelected", void 0);

    _defineProperty(this, "parent", void 0);

    _defineProperty(this, "children", void 0);

    _defineProperty(this, "content", void 0);

    _defineProperty(this, "state", void 0);

    _defineProperty(this, "layers", void 0);

    _defineProperty(this, "id", void 0);

    _defineProperty(this, "zoom", void 0);

    _defineProperty(this, "userData", void 0);

    _defineProperty(this, "boundingBox", void 0);

    _defineProperty(this, "_abortController", void 0);

    _defineProperty(this, "_loader", void 0);

    _defineProperty(this, "_loaderId", void 0);

    _defineProperty(this, "_isLoaded", void 0);

    _defineProperty(this, "_isCancelled", void 0);

    _defineProperty(this, "_needsReload", void 0);

    _defineProperty(this, "_bbox", void 0);

    this.index = index;
    this.isVisible = false;
    this.isSelected = false;
    this.parent = null;
    this.children = [];
    this.content = null;
    this._loader = undefined;
    this._abortController = null;
    this._loaderId = 0;
    this._isLoaded = false;
    this._isCancelled = false;
    this._needsReload = false;
  }

  get bbox() {
    return this._bbox;
  }

  set bbox(value) {
    if (this._bbox) return;
    this._bbox = value;

    if ('west' in value) {
      this.boundingBox = [[value.west, value.south], [value.east, value.north]];
    } else {
      this.boundingBox = [[value.left, value.top], [value.right, value.bottom]];
    }
  }

  get data() {
    return this.isLoading && this._loader ? this._loader.then(() => this.data) : this.content;
  }

  get isLoaded() {
    return this._isLoaded && !this._needsReload;
  }

  get isLoading() {
    return Boolean(this._loader) && !this._isCancelled;
  }

  get needsReload() {
    return this._needsReload || this._isCancelled;
  }

  get byteLength() {
    const result = this.content ? this.content.byteLength : 0;

    if (!Number.isFinite(result)) {
      console.error('byteLength not defined in tile data');
    }

    return result;
  }

  async _loadData({
    getData,
    requestScheduler,
    onLoad,
    onError
  }) {
    const {
      index,
      id,
      bbox,
      userData,
      zoom
    } = this;
    const loaderId = this._loaderId;
    this._abortController = new AbortController();
    const {
      signal
    } = this._abortController;
    const requestToken = await requestScheduler.scheduleRequest(this, tile => {
      return tile.isSelected ? 1 : -1;
    });

    if (!requestToken) {
      this._isCancelled = true;
      return;
    }

    if (this._isCancelled) {
      requestToken.done();
      return;
    }

    let tileData = null;
    let error;

    try {
      tileData = await getData({
        index,
        id,
        bbox,
        userData,
        zoom,
        signal
      });
    } catch (err) {
      error = err || true;
    } finally {
      requestToken.done();
    }

    if (loaderId !== this._loaderId) {
      return;
    }

    this._loader = undefined;
    this.content = tileData;

    if (this._isCancelled && !tileData) {
      this._isLoaded = false;
      return;
    }

    this._isLoaded = true;
    this._isCancelled = false;

    if (error) {
      onError(error, this);
    } else {
      onLoad(this);
    }
  }

  loadData(opts) {
    this._isLoaded = false;
    this._isCancelled = false;
    this._needsReload = false;
    this._loaderId++;
    this._loader = this._loadData(opts);
    return this._loader;
  }

  setNeedsReload() {
    if (this.isLoading) {
      this.abort();
      this._loader = undefined;
    }

    this._needsReload = true;
  }

  abort() {
    var _this$_abortControlle;

    if (this.isLoaded) {
      return;
    }

    this._isCancelled = true;
    (_this$_abortControlle = this._abortController) === null || _this$_abortControlle === void 0 ? void 0 : _this$_abortControlle.abort();
  }

}
//# sourceMappingURL=tile-2d-header.js.map