import _defineProperty from "@babel/runtime/helpers/esm/defineProperty";
import { PathLayer } from '@deck.gl/layers';
const defaultProps = {
  fadeTrail: true,
  trailLength: {
    type: 'number',
    value: 120,
    min: 0
  },
  currentTime: {
    type: 'number',
    value: 0,
    min: 0
  },
  getTimestamps: {
    type: 'accessor',
    value: d => d.timestamps
  }
};
export default class TripsLayer extends PathLayer {
  getShaders() {
    const shaders = super.getShaders();
    shaders.inject = {
      'vs:#decl': "uniform float trailLength;\nattribute float instanceTimestamps;\nattribute float instanceNextTimestamps;\nvarying float vTime;\n",
      'vs:#main-end': "vTime = instanceTimestamps + (instanceNextTimestamps - instanceTimestamps) * vPathPosition.y / vPathLength;\n",
      'fs:#decl': "uniform bool fadeTrail;\nuniform float trailLength;\nuniform float currentTime;\nvarying float vTime;\n",
      'fs:#main-start': "if(vTime > currentTime || (fadeTrail && (vTime < currentTime - trailLength))) {\n  discard;\n}\n",
      'fs:DECKGL_FILTER_COLOR': "if(fadeTrail) {\n  color.a *= 1.0 - (currentTime - vTime) / trailLength;\n}\n"
    };
    return shaders;
  }

  initializeState() {
    super.initializeState();
    const attributeManager = this.getAttributeManager();
    attributeManager.addInstanced({
      timestamps: {
        size: 1,
        accessor: 'getTimestamps',
        shaderAttributes: {
          instanceTimestamps: {
            vertexOffset: 0
          },
          instanceNextTimestamps: {
            vertexOffset: 1
          }
        }
      }
    });
  }

  draw(params) {
    const {
      fadeTrail,
      trailLength,
      currentTime
    } = this.props;
    params.uniforms = { ...params.uniforms,
      fadeTrail,
      trailLength,
      currentTime
    };
    super.draw(params);
  }

}

_defineProperty(TripsLayer, "layerName", 'TripsLayer');

_defineProperty(TripsLayer, "defaultProps", defaultProps);
//# sourceMappingURL=trips-layer.js.map