import { lngLatToWorld } from '@math.gl/web-mercator';
const HALF_EARTH_CIRCUMFERENCE = 6378137 * Math.PI;
export function WGS84ToPseudoMercator(coord) {
  const mercator = lngLatToWorld(coord);
  mercator[0] = (mercator[0] / 256 - 1) * HALF_EARTH_CIRCUMFERENCE;
  mercator[1] = (mercator[1] / 256 - 1) * HALF_EARTH_CIRCUMFERENCE;
  return mercator;
}
//# sourceMappingURL=utils.js.map