"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _core = require("@deck.gl/core");

var _deckUtils = require("./deck-utils");

var _resolveLayers = require("./resolve-layers");

var _excluded = ["interleaved"];

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { (0, _defineProperty2.default)(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

var MapboxOverlay = function () {
  function MapboxOverlay(props) {
    var _this = this;

    (0, _classCallCheck2.default)(this, MapboxOverlay);
    (0, _defineProperty2.default)(this, "_props", void 0);
    (0, _defineProperty2.default)(this, "_deck", void 0);
    (0, _defineProperty2.default)(this, "_map", void 0);
    (0, _defineProperty2.default)(this, "_container", void 0);
    (0, _defineProperty2.default)(this, "_interleaved", void 0);
    (0, _defineProperty2.default)(this, "_lastMouseDownPoint", void 0);
    (0, _defineProperty2.default)(this, "_handleStyleChange", function () {
      (0, _resolveLayers.resolveLayers)(_this._map, _this._deck, _this._props.layers, _this._props.layers);
    });
    (0, _defineProperty2.default)(this, "_updateContainerSize", function () {
      if (_this._map && _this._container) {
        var _this$_map$getContain = _this._map.getContainer(),
            clientWidth = _this$_map$getContain.clientWidth,
            clientHeight = _this$_map$getContain.clientHeight;

        Object.assign(_this._container.style, {
          width: "".concat(clientWidth, "px"),
          height: "".concat(clientHeight, "px")
        });
      }
    });
    (0, _defineProperty2.default)(this, "_updateViewState", function () {
      var deck = _this._deck;

      if (deck) {
        deck.setProps({
          viewState: (0, _deckUtils.getViewState)(_this._map)
        });

        if (deck.isInitialized) {
          deck.redraw();
        }
      }
    });
    (0, _defineProperty2.default)(this, "_handleMouseEvent", function (event) {
      var deck = _this._deck;

      if (!deck || !deck.isInitialized) {
        return;
      }

      var mockEvent = {
        type: event.type,
        offsetCenter: event.point,
        srcEvent: event
      };
      var lastDown = _this._lastMouseDownPoint;

      if (!event.point && lastDown) {
        mockEvent.deltaX = event.originalEvent.clientX - lastDown.clientX;
        mockEvent.deltaY = event.originalEvent.clientY - lastDown.clientY;
        mockEvent.offsetCenter = {
          x: lastDown.x + mockEvent.deltaX,
          y: lastDown.y + mockEvent.deltaY
        };
      }

      switch (mockEvent.type) {
        case 'mousedown':
          deck._onPointerDown(mockEvent);

          _this._lastMouseDownPoint = _objectSpread(_objectSpread({}, event.point), {}, {
            clientX: event.originalEvent.clientX,
            clientY: event.originalEvent.clientY
          });
          break;

        case 'dragstart':
          mockEvent.type = 'panstart';

          deck._onEvent(mockEvent);

          break;

        case 'drag':
          mockEvent.type = 'panmove';

          deck._onEvent(mockEvent);

          break;

        case 'dragend':
          mockEvent.type = 'panend';

          deck._onEvent(mockEvent);

          break;

        case 'click':
          mockEvent.tapCount = 1;

          deck._onEvent(mockEvent);

          break;

        case 'dblclick':
          mockEvent.type = 'click';
          mockEvent.tapCount = 2;

          deck._onEvent(mockEvent);

          break;

        case 'mousemove':
          mockEvent.type = 'pointermove';

          deck._onPointerMove(mockEvent);

          break;

        case 'mouseout':
          mockEvent.type = 'pointerleave';

          deck._onPointerMove(mockEvent);

          break;

        default:
          return;
      }
    });
    var _props$interleaved = props.interleaved,
        interleaved = _props$interleaved === void 0 ? false : _props$interleaved,
        otherProps = (0, _objectWithoutProperties2.default)(props, _excluded);
    this._interleaved = interleaved;
    this._props = otherProps;
  }

  (0, _createClass2.default)(MapboxOverlay, [{
    key: "setProps",
    value: function setProps(props) {
      if (this._interleaved && props.layers) {
        (0, _resolveLayers.resolveLayers)(this._map, this._deck, this._props.layers, props.layers);
      }

      Object.assign(this._props, props);

      if (this._deck) {
        this._deck.setProps(this._interleaved ? (0, _deckUtils.getInterleavedProps)(this._props) : this._props);
      }
    }
  }, {
    key: "onAdd",
    value: function onAdd(map) {
      this._map = map;
      return this._interleaved ? this._onAddInterleaved(map) : this._onAddOverlaid(map);
    }
  }, {
    key: "_onAddOverlaid",
    value: function _onAddOverlaid(map) {
      var container = document.createElement('div');
      Object.assign(container.style, {
        position: 'absolute',
        left: 0,
        top: 0,
        textAlign: 'initial',
        pointerEvents: 'none'
      });
      this._container = container;
      this._deck = new _core.Deck(_objectSpread(_objectSpread({}, this._props), {}, {
        parent: container,
        viewState: (0, _deckUtils.getViewState)(map)
      }));
      map.on('resize', this._updateContainerSize);
      map.on('render', this._updateViewState);
      map.on('mousedown', this._handleMouseEvent);
      map.on('dragstart', this._handleMouseEvent);
      map.on('drag', this._handleMouseEvent);
      map.on('dragend', this._handleMouseEvent);
      map.on('mousemove', this._handleMouseEvent);
      map.on('mouseout', this._handleMouseEvent);
      map.on('click', this._handleMouseEvent);
      map.on('dblclick', this._handleMouseEvent);

      this._updateContainerSize();

      return container;
    }
  }, {
    key: "_onAddInterleaved",
    value: function _onAddInterleaved(map) {
      this._deck = (0, _deckUtils.getDeckInstance)({
        map: map,
        gl: map.painter.context.gl,
        deck: new _core.Deck(_objectSpread(_objectSpread({}, this._props), {}, {
          gl: map.painter.context.gl
        }))
      });
      map.on('styledata', this._handleStyleChange);
      (0, _resolveLayers.resolveLayers)(map, this._deck, [], this._props.layers);
      return document.createElement('div');
    }
  }, {
    key: "onRemove",
    value: function onRemove() {
      var map = this._map;

      if (map) {
        if (this._interleaved) {
          this._onRemoveInterleaved(map);
        } else {
          this._onRemoveOverlaid(map);
        }
      }

      this._deck = undefined;
      this._map = undefined;
      this._container = undefined;
    }
  }, {
    key: "_onRemoveOverlaid",
    value: function _onRemoveOverlaid(map) {
      var _this$_deck;

      map.off('resize', this._updateContainerSize);
      map.off('render', this._updateViewState);
      map.off('mousedown', this._handleMouseEvent);
      map.off('dragstart', this._handleMouseEvent);
      map.off('drag', this._handleMouseEvent);
      map.off('dragend', this._handleMouseEvent);
      map.off('mousemove', this._handleMouseEvent);
      map.off('mouseout', this._handleMouseEvent);
      map.off('click', this._handleMouseEvent);
      map.off('dblclick', this._handleMouseEvent);
      (_this$_deck = this._deck) === null || _this$_deck === void 0 ? void 0 : _this$_deck.finalize();
    }
  }, {
    key: "_onRemoveInterleaved",
    value: function _onRemoveInterleaved(map) {
      map.off('styledata', this._handleStyleChange);
      (0, _resolveLayers.resolveLayers)(map, this._deck, this._props.layers, []);
      (0, _deckUtils.removeDeckInstance)(map);
    }
  }, {
    key: "getDefaultPosition",
    value: function getDefaultPosition() {
      return 'top-left';
    }
  }, {
    key: "pickObject",
    value: function pickObject(params) {
      (0, _core.assert)(this._deck);
      return this._deck.pickObject(params);
    }
  }, {
    key: "pickMultipleObjects",
    value: function pickMultipleObjects(params) {
      (0, _core.assert)(this._deck);
      return this._deck.pickMultipleObjects(params);
    }
  }, {
    key: "pickObjects",
    value: function pickObjects(params) {
      (0, _core.assert)(this._deck);
      return this._deck.pickObjects(params);
    }
  }, {
    key: "finalize",
    value: function finalize() {
      if (this._map) {
        this._map.removeControl(this);
      }
    }
  }, {
    key: "getCanvas",
    value: function getCanvas() {
      if (!this._map) {
        return null;
      }

      return this._interleaved ? this._map.getCanvas() : this._deck.getCanvas();
    }
  }]);
  return MapboxOverlay;
}();

exports.default = MapboxOverlay;
//# sourceMappingURL=mapbox-overlay.js.map