"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.resolveLayers = resolveLayers;

var _core = require("@deck.gl/core");

var _mapboxLayer = _interopRequireDefault(require("./mapbox-layer"));

function _createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it.return != null) it.return(); } finally { if (didErr) throw err; } } }; }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

var UNDEFINED_BEFORE_ID = '__UNDEFINED__';

function resolveLayers(map, deck, oldLayers, newLayers) {
  if (!map || !deck || !map.style || !map.style._loaded) {
    return;
  }

  var layers = (0, _core._flatten)(newLayers, Boolean);

  if (oldLayers !== newLayers) {
    var prevLayers = (0, _core._flatten)(oldLayers, Boolean);
    var prevLayerIds = new Set(prevLayers.map(function (l) {
      return l.id;
    }));

    var _iterator = _createForOfIteratorHelper(layers),
        _step;

    try {
      for (_iterator.s(); !(_step = _iterator.n()).done;) {
        var layer = _step.value;
        prevLayerIds.delete(layer.id);
      }
    } catch (err) {
      _iterator.e(err);
    } finally {
      _iterator.f();
    }

    var _iterator2 = _createForOfIteratorHelper(prevLayerIds),
        _step2;

    try {
      for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
        var id = _step2.value;

        if (map.getLayer(id)) {
          map.removeLayer(id);
        }
      }
    } catch (err) {
      _iterator2.e(err);
    } finally {
      _iterator2.f();
    }
  }

  var _iterator3 = _createForOfIteratorHelper(layers),
      _step3;

  try {
    for (_iterator3.s(); !(_step3 = _iterator3.n()).done;) {
      var _layer = _step3.value;
      var mapboxLayer = map.getLayer(_layer.id);

      if (mapboxLayer) {
        mapboxLayer.implementation.setProps(_layer.props);
      } else {
        map.addLayer(new _mapboxLayer.default({
          id: _layer.id,
          deck: deck
        }), _layer.props.beforeId);
      }
    }
  } catch (err) {
    _iterator3.e(err);
  } finally {
    _iterator3.f();
  }

  var mapLayers = map.style._order;
  var layerGroups = {};

  var _iterator4 = _createForOfIteratorHelper(layers),
      _step4;

  try {
    for (_iterator4.s(); !(_step4 = _iterator4.n()).done;) {
      var _layer2 = _step4.value;
      var _beforeId = _layer2.props.beforeId;

      if (!_beforeId || !mapLayers.includes(_beforeId)) {
        _beforeId = UNDEFINED_BEFORE_ID;
      }

      layerGroups[_beforeId] = layerGroups[_beforeId] || [];

      layerGroups[_beforeId].push(_layer2.id);
    }
  } catch (err) {
    _iterator4.e(err);
  } finally {
    _iterator4.f();
  }

  for (var beforeId in layerGroups) {
    var layerGroup = layerGroups[beforeId];
    var lastLayerIndex = beforeId === UNDEFINED_BEFORE_ID ? mapLayers.length : mapLayers.indexOf(beforeId);
    var lastLayerId = beforeId === UNDEFINED_BEFORE_ID ? undefined : beforeId;

    for (var i = layerGroup.length - 1; i >= 0; i--) {
      var layerId = layerGroup[i];
      var layerIndex = mapLayers.indexOf(layerId);

      if (layerIndex !== lastLayerIndex - 1) {
        map.moveLayer(layerId, lastLayerId);

        if (layerIndex > lastLayerIndex) {
          lastLayerIndex++;
        }
      }

      lastLayerIndex--;
      lastLayerId = layerId;
    }
  }
}
//# sourceMappingURL=resolve-layers.js.map