import { _flatten as flatten } from '@deck.gl/core';
import MapboxLayer from './mapbox-layer';
const UNDEFINED_BEFORE_ID = '__UNDEFINED__';
export function resolveLayers(map, deck, oldLayers, newLayers) {
  if (!map || !deck || !map.style || !map.style._loaded) {
    return;
  }

  const layers = flatten(newLayers, Boolean);

  if (oldLayers !== newLayers) {
    const prevLayers = flatten(oldLayers, Boolean);
    const prevLayerIds = new Set(prevLayers.map(l => l.id));

    for (const layer of layers) {
      prevLayerIds.delete(layer.id);
    }

    for (const id of prevLayerIds) {
      if (map.getLayer(id)) {
        map.removeLayer(id);
      }
    }
  }

  for (const layer of layers) {
    const mapboxLayer = map.getLayer(layer.id);

    if (mapboxLayer) {
      mapboxLayer.implementation.setProps(layer.props);
    } else {
      map.addLayer(new MapboxLayer({
        id: layer.id,
        deck
      }), layer.props.beforeId);
    }
  }

  const mapLayers = map.style._order;
  const layerGroups = {};

  for (const layer of layers) {
    let {
      beforeId
    } = layer.props;

    if (!beforeId || !mapLayers.includes(beforeId)) {
      beforeId = UNDEFINED_BEFORE_ID;
    }

    layerGroups[beforeId] = layerGroups[beforeId] || [];
    layerGroups[beforeId].push(layer.id);
  }

  for (const beforeId in layerGroups) {
    const layerGroup = layerGroups[beforeId];
    let lastLayerIndex = beforeId === UNDEFINED_BEFORE_ID ? mapLayers.length : mapLayers.indexOf(beforeId);
    let lastLayerId = beforeId === UNDEFINED_BEFORE_ID ? undefined : beforeId;

    for (let i = layerGroup.length - 1; i >= 0; i--) {
      const layerId = layerGroup[i];
      const layerIndex = mapLayers.indexOf(layerId);

      if (layerIndex !== lastLayerIndex - 1) {
        map.moveLayer(layerId, lastLayerId);

        if (layerIndex > lastLayerIndex) {
          lastLayerIndex++;
        }
      }

      lastLayerIndex--;
      lastLayerId = layerId;
    }
  }
}
//# sourceMappingURL=resolve-layers.js.map