import { Deck } from '@deck.gl/core/typed';
import type { DeckProps, MapViewState } from '@deck.gl/core/typed';
import type MapboxLayer from './mapbox-layer';
import type { Map } from 'mapbox-gl';
export declare function getDeckInstance({ map, gl, deck }: {
    map: Map & {
        __deck?: Deck | null;
    };
    gl: WebGLRenderingContext;
    deck?: Deck;
}): Deck;
export declare function removeDeckInstance(map: Map & {
    __deck?: Deck | null;
}): void;
export declare function getInterleavedProps(currProps: DeckProps): DeckProps;
export declare function addLayer(deck: Deck, layer: MapboxLayer<any>): void;
export declare function removeLayer(deck: Deck, layer: MapboxLayer<any>): void;
export declare function updateLayer(deck: Deck, layer: MapboxLayer<any>): void;
export declare function drawLayer(deck: Deck, map: Map, layer: MapboxLayer<any>): void;
export declare function getViewState(map: Map): MapViewState & {
    repeat: boolean;
    padding: {
        left: number;
        right: number;
        top: number;
        bottom: number;
    };
};
//# sourceMappingURL=deck-utils.d.ts.map