"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _assertThisInitialized2 = _interopRequireDefault(require("@babel/runtime/helpers/assertThisInitialized"));

var _get2 = _interopRequireDefault(require("@babel/runtime/helpers/get"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _typeof2 = _interopRequireDefault(require("@babel/runtime/helpers/typeof"));

var _core = require("@deck.gl/core");

var _core2 = require("@luma.gl/core");

var _shadertools = require("@luma.gl/shadertools");

var _experimental = require("@luma.gl/experimental");

var _gltf = require("@loaders.gl/gltf");

var _gltfUtils = require("./gltf-utils");

var _matrix = require("../utils/matrix");

var _scenegraphLayerVertex = _interopRequireDefault(require("./scenegraph-layer-vertex.glsl"));

var _scenegraphLayerFragment = _interopRequireDefault(require("./scenegraph-layer-fragment.glsl"));

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { (0, _defineProperty2.default)(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

var DEFAULT_COLOR = [255, 255, 255, 255];
var defaultProps = {
  scenegraph: {
    type: 'object',
    value: null,
    async: true
  },
  getScene: function getScene(gltf) {
    if (gltf && gltf.scenes) {
      return (0, _typeof2.default)(gltf.scene) === 'object' ? gltf.scene : gltf.scenes[gltf.scene || 0];
    }

    return gltf;
  },
  getAnimator: function getAnimator(scenegraph) {
    return scenegraph && scenegraph.animator;
  },
  _animations: null,
  sizeScale: {
    type: 'number',
    value: 1,
    min: 0
  },
  sizeMinPixels: {
    type: 'number',
    min: 0,
    value: 0
  },
  sizeMaxPixels: {
    type: 'number',
    min: 0,
    value: Number.MAX_SAFE_INTEGER
  },
  getPosition: {
    type: 'accessor',
    value: function value(x) {
      return x.position;
    }
  },
  getColor: {
    type: 'accessor',
    value: DEFAULT_COLOR
  },
  _lighting: 'flat',
  _imageBasedLightingEnvironment: null,
  getOrientation: {
    type: 'accessor',
    value: [0, 0, 0]
  },
  getScale: {
    type: 'accessor',
    value: [1, 1, 1]
  },
  getTranslation: {
    type: 'accessor',
    value: [0, 0, 0]
  },
  getTransformMatrix: {
    type: 'accessor',
    value: []
  },
  loaders: [_gltf.GLTFLoader]
};

var ScenegraphLayer = function (_Layer) {
  (0, _inherits2.default)(ScenegraphLayer, _Layer);

  var _super = _createSuper(ScenegraphLayer);

  function ScenegraphLayer() {
    var _this;

    (0, _classCallCheck2.default)(this, ScenegraphLayer);

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    _this = _super.call.apply(_super, [this].concat(args));
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "state", void 0);
    return _this;
  }

  (0, _createClass2.default)(ScenegraphLayer, [{
    key: "getShaders",
    value: function getShaders() {
      var modules = [_core.project32, _core.picking];

      if (this.props._lighting === 'pbr') {
        modules.push(_shadertools.pbr);
      }

      return (0, _get2.default)((0, _getPrototypeOf2.default)(ScenegraphLayer.prototype), "getShaders", this).call(this, {
        vs: _scenegraphLayerVertex.default,
        fs: _scenegraphLayerFragment.default,
        modules: modules
      });
    }
  }, {
    key: "initializeState",
    value: function initializeState() {
      var attributeManager = this.getAttributeManager();
      attributeManager.addInstanced({
        instancePositions: {
          size: 3,
          type: 5130,
          fp64: this.use64bitPositions(),
          accessor: 'getPosition',
          transition: true
        },
        instanceColors: {
          type: 5121,
          size: this.props.colorFormat.length,
          accessor: 'getColor',
          normalized: true,
          defaultValue: DEFAULT_COLOR,
          transition: true
        },
        instanceModelMatrix: _matrix.MATRIX_ATTRIBUTES
      });
    }
  }, {
    key: "updateState",
    value: function updateState(params) {
      (0, _get2.default)((0, _getPrototypeOf2.default)(ScenegraphLayer.prototype), "updateState", this).call(this, params);
      var props = params.props,
          oldProps = params.oldProps;

      if (props.scenegraph !== oldProps.scenegraph) {
        this._updateScenegraph();
      } else if (props._animations !== oldProps._animations) {
        this._applyAnimationsProp(this.state.scenegraph, this.state.animator, props._animations);
      }
    }
  }, {
    key: "finalizeState",
    value: function finalizeState(context) {
      (0, _get2.default)((0, _getPrototypeOf2.default)(ScenegraphLayer.prototype), "finalizeState", this).call(this, context);

      this._deleteScenegraph();
    }
  }, {
    key: "isLoaded",
    get: function get() {
      var _this$state;

      return ((_this$state = this.state) === null || _this$state === void 0 ? void 0 : _this$state.scenegraph) && (0, _get2.default)((0, _getPrototypeOf2.default)(ScenegraphLayer.prototype), "isLoaded", this);
    }
  }, {
    key: "_updateScenegraph",
    value: function _updateScenegraph() {
      var _this2 = this;

      var props = this.props;
      var gl = this.context.gl;
      var scenegraphData = null;

      if (props.scenegraph instanceof _experimental.ScenegraphNode) {
        scenegraphData = {
          scenes: [props.scenegraph]
        };
      } else if (props.scenegraph && !props.scenegraph.gltf) {
        var gltf = props.scenegraph;
        var gltfObjects = (0, _experimental.createGLTFObjects)(gl, gltf, this._getModelOptions());
        scenegraphData = _objectSpread({
          gltf: gltf
        }, gltfObjects);
        (0, _gltfUtils.waitForGLTFAssets)(gltfObjects).then(function () {
          return _this2.setNeedsRedraw();
        });
      } else if (props.scenegraph) {
        _core.log.deprecated('ScenegraphLayer.props.scenegraph', 'Use GLTFLoader instead of GLTFScenegraphLoader')();

        scenegraphData = props.scenegraph;
      }

      var options = {
        layer: this,
        gl: gl
      };
      var scenegraph = props.getScene(scenegraphData, options);
      var animator = props.getAnimator(scenegraphData, options);

      if (scenegraph instanceof _experimental.ScenegraphNode) {
        this._deleteScenegraph();

        this._applyAllAttributes(scenegraph);

        this._applyAnimationsProp(scenegraph, animator, props._animations);

        this.setState({
          scenegraph: scenegraph,
          animator: animator
        });
      } else if (scenegraph !== null) {
        _core.log.warn('invalid scenegraph:', scenegraph)();
      }
    }
  }, {
    key: "_applyAllAttributes",
    value: function _applyAllAttributes(scenegraph) {
      var _this3 = this;

      if (this.state.attributesAvailable) {
        var allAttributes = this.getAttributeManager().getAttributes();
        scenegraph.traverse(function (model) {
          _this3._setModelAttributes(model.model, allAttributes);
        });
      }
    }
  }, {
    key: "_applyAnimationsProp",
    value: function _applyAnimationsProp(scenegraph, animator, animationsProp) {
      if (!scenegraph || !animator || !animationsProp) {
        return;
      }

      var animations = animator.getAnimations();
      Object.keys(animationsProp).sort().forEach(function (key) {
        var value = animationsProp[key];

        if (key === '*') {
          animations.forEach(function (animation) {
            Object.assign(animation, value);
          });
        } else if (Number.isFinite(Number(key))) {
          var number = Number(key);

          if (number >= 0 && number < animations.length) {
            Object.assign(animations[number], value);
          } else {
            _core.log.warn("animation ".concat(key, " not found"))();
          }
        } else {
          var findResult = animations.find(function (_ref) {
            var name = _ref.name;
            return name === key;
          });

          if (findResult) {
            Object.assign(findResult, value);
          } else {
            _core.log.warn("animation ".concat(key, " not found"))();
          }
        }
      });
    }
  }, {
    key: "_deleteScenegraph",
    value: function _deleteScenegraph() {
      var scenegraph = this.state.scenegraph;

      if (scenegraph instanceof _experimental.ScenegraphNode) {
        scenegraph.delete();
      }
    }
  }, {
    key: "_getModelOptions",
    value: function _getModelOptions() {
      var _imageBasedLightingEnvironment = this.props._imageBasedLightingEnvironment;
      var env = null;

      if (_imageBasedLightingEnvironment) {
        if (typeof _imageBasedLightingEnvironment === 'function') {
          env = _imageBasedLightingEnvironment({
            gl: this.context.gl,
            layer: this
          });
        } else {
          env = _imageBasedLightingEnvironment;
        }
      }

      return {
        gl: this.context.gl,
        waitForFullLoad: true,
        imageBasedLightingEnvironment: env,
        modelOptions: _objectSpread({
          isInstanced: true,
          transpileToGLSL100: !(0, _core2.isWebGL2)(this.context.gl)
        }, this.getShaders()),
        useTangents: false
      };
    }
  }, {
    key: "updateAttributes",
    value: function updateAttributes(changedAttributes) {
      var _this4 = this;

      this.setState({
        attributesAvailable: true
      });
      if (!this.state.scenegraph) return;
      this.state.scenegraph.traverse(function (model) {
        _this4._setModelAttributes(model.model, changedAttributes);
      });
    }
  }, {
    key: "draw",
    value: function draw(_ref2) {
      var _ref2$moduleParameter = _ref2.moduleParameters,
          moduleParameters = _ref2$moduleParameter === void 0 ? null : _ref2$moduleParameter,
          _ref2$parameters = _ref2.parameters,
          parameters = _ref2$parameters === void 0 ? {} : _ref2$parameters,
          context = _ref2.context;
      if (!this.state.scenegraph) return;

      if (this.props._animations && this.state.animator) {
        this.state.animator.animate(context.timeline.getTime());
        this.setNeedsRedraw();
      }

      var viewport = this.context.viewport;
      var _this$props = this.props,
          sizeScale = _this$props.sizeScale,
          sizeMinPixels = _this$props.sizeMinPixels,
          sizeMaxPixels = _this$props.sizeMaxPixels,
          opacity = _this$props.opacity,
          coordinateSystem = _this$props.coordinateSystem;
      var numInstances = this.getNumInstances();
      this.state.scenegraph.traverse(function (model, _ref3) {
        var worldMatrix = _ref3.worldMatrix;
        model.model.setInstanceCount(numInstances);
        model.updateModuleSettings(moduleParameters);
        model.draw({
          parameters: parameters,
          uniforms: {
            sizeScale: sizeScale,
            opacity: opacity,
            sizeMinPixels: sizeMinPixels,
            sizeMaxPixels: sizeMaxPixels,
            composeModelMatrix: (0, _matrix.shouldComposeModelMatrix)(viewport, coordinateSystem),
            sceneModelMatrix: worldMatrix,
            u_Camera: model.model.getUniforms().project_uCameraPosition
          }
        });
      });
    }
  }]);
  return ScenegraphLayer;
}(_core.Layer);

exports.default = ScenegraphLayer;
(0, _defineProperty2.default)(ScenegraphLayer, "defaultProps", defaultProps);
(0, _defineProperty2.default)(ScenegraphLayer, "layerName", 'ScenegraphLayer');
//# sourceMappingURL=scenegraph-layer.js.map