"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _assertThisInitialized2 = _interopRequireDefault(require("@babel/runtime/helpers/assertThisInitialized"));

var _get2 = _interopRequireDefault(require("@babel/runtime/helpers/get"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _core = require("@deck.gl/core");

var _core2 = require("@luma.gl/core");

var _webgl = require("@luma.gl/webgl");

var _matrix = require("../utils/matrix");

var _simpleMeshLayerVertex = _interopRequireDefault(require("./simple-mesh-layer-vertex.glsl"));

var _simpleMeshLayerFragment = _interopRequireDefault(require("./simple-mesh-layer-fragment.glsl"));

var _schema = require("@loaders.gl/schema");

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { (0, _defineProperty2.default)(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function validateGeometryAttributes(attributes, useMeshColors) {
  var hasColorAttribute = attributes.COLOR_0 || attributes.colors;
  var useColorAttribute = hasColorAttribute && useMeshColors;

  if (!useColorAttribute) {
    attributes.colors = {
      constant: true,
      value: new Float32Array([1, 1, 1])
    };
  }

  _core.log.assert(attributes.positions || attributes.POSITION, 'no "postions" or "POSITION" attribute in mesh');
}

function getGeometry(data, useMeshColors) {
  if (data.attributes) {
    validateGeometryAttributes(data.attributes, useMeshColors);

    if (data instanceof _core2.Geometry) {
      return data;
    } else {
      return new _core2.Geometry(data);
    }
  } else if (data.positions || data.POSITION) {
    validateGeometryAttributes(data, useMeshColors);
    return new _core2.Geometry({
      attributes: data
    });
  }

  throw Error('Invalid mesh');
}

var DEFAULT_COLOR = [0, 0, 0, 255];
var defaultProps = {
  mesh: {
    type: 'object',
    value: null,
    async: true
  },
  texture: {
    type: 'image',
    value: null,
    async: true
  },
  sizeScale: {
    type: 'number',
    value: 1,
    min: 0
  },
  _useMeshColors: {
    type: 'boolean',
    value: false
  },
  _instanced: true,
  wireframe: false,
  material: true,
  getPosition: {
    type: 'accessor',
    value: function value(x) {
      return x.position;
    }
  },
  getColor: {
    type: 'accessor',
    value: DEFAULT_COLOR
  },
  getOrientation: {
    type: 'accessor',
    value: [0, 0, 0]
  },
  getScale: {
    type: 'accessor',
    value: [1, 1, 1]
  },
  getTranslation: {
    type: 'accessor',
    value: [0, 0, 0]
  },
  getTransformMatrix: {
    type: 'accessor',
    value: []
  },
  textureParameters: {
    type: 'object',
    ignore: true
  }
};

var SimpleMeshLayer = function (_Layer) {
  (0, _inherits2.default)(SimpleMeshLayer, _Layer);

  var _super = _createSuper(SimpleMeshLayer);

  function SimpleMeshLayer() {
    var _this;

    (0, _classCallCheck2.default)(this, SimpleMeshLayer);

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    _this = _super.call.apply(_super, [this].concat(args));
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "state", void 0);
    return _this;
  }

  (0, _createClass2.default)(SimpleMeshLayer, [{
    key: "getShaders",
    value: function getShaders() {
      var transpileToGLSL100 = !(0, _core2.isWebGL2)(this.context.gl);
      var defines = {};

      if ((0, _webgl.hasFeature)(this.context.gl, _webgl.FEATURES.GLSL_DERIVATIVES)) {
        defines.DERIVATIVES_AVAILABLE = 1;
      }

      return (0, _get2.default)((0, _getPrototypeOf2.default)(SimpleMeshLayer.prototype), "getShaders", this).call(this, {
        vs: _simpleMeshLayerVertex.default,
        fs: _simpleMeshLayerFragment.default,
        modules: [_core.project32, _core.phongLighting, _core.picking],
        transpileToGLSL100: transpileToGLSL100,
        defines: defines
      });
    }
  }, {
    key: "getBounds",
    value: function getBounds() {
      var _mesh$header;

      if (this.props._instanced) {
        return (0, _get2.default)((0, _getPrototypeOf2.default)(SimpleMeshLayer.prototype), "getBounds", this).call(this);
      }

      var result = this.state.positionBounds;

      if (result) {
        return result;
      }

      var mesh = this.props.mesh;

      if (!mesh) {
        return null;
      }

      result = (_mesh$header = mesh.header) === null || _mesh$header === void 0 ? void 0 : _mesh$header.boundingBox;

      if (!result) {
        var _getGeometry = getGeometry(mesh, this.props._useMeshColors),
            attributes = _getGeometry.attributes;

        attributes.POSITION = attributes.POSITION || attributes.positions;
        result = (0, _schema.getMeshBoundingBox)(attributes);
      }

      this.state.positionBounds = result;
      return result;
    }
  }, {
    key: "initializeState",
    value: function initializeState() {
      var attributeManager = this.getAttributeManager();
      attributeManager.addInstanced({
        instancePositions: {
          transition: true,
          type: 5130,
          fp64: this.use64bitPositions(),
          size: 3,
          accessor: 'getPosition'
        },
        instanceColors: {
          type: 5121,
          transition: true,
          size: this.props.colorFormat.length,
          normalized: true,
          accessor: 'getColor',
          defaultValue: [0, 0, 0, 255]
        },
        instanceModelMatrix: _matrix.MATRIX_ATTRIBUTES
      });
      this.setState({
        emptyTexture: new _core2.Texture2D(this.context.gl, {
          data: new Uint8Array(4),
          width: 1,
          height: 1
        })
      });
    }
  }, {
    key: "updateState",
    value: function updateState(params) {
      (0, _get2.default)((0, _getPrototypeOf2.default)(SimpleMeshLayer.prototype), "updateState", this).call(this, params);
      var props = params.props,
          oldProps = params.oldProps,
          changeFlags = params.changeFlags;

      if (props.mesh !== oldProps.mesh || changeFlags.extensionsChanged) {
        var _this$state$model;

        this.state.positionBounds = null;
        (_this$state$model = this.state.model) === null || _this$state$model === void 0 ? void 0 : _this$state$model.delete();

        if (props.mesh) {
          this.state.model = this.getModel(props.mesh);
          var attributes = props.mesh.attributes || props.mesh;
          this.setState({
            hasNormals: Boolean(attributes.NORMAL || attributes.normals)
          });
        }

        this.getAttributeManager().invalidateAll();
      }

      if (props.texture !== oldProps.texture) {
        this.setTexture(props.texture);
      }

      if (this.state.model) {
        this.state.model.setDrawMode(this.props.wireframe ? 3 : 4);
      }
    }
  }, {
    key: "finalizeState",
    value: function finalizeState(context) {
      (0, _get2.default)((0, _getPrototypeOf2.default)(SimpleMeshLayer.prototype), "finalizeState", this).call(this, context);
      this.state.emptyTexture.delete();
    }
  }, {
    key: "draw",
    value: function draw(_ref) {
      var uniforms = _ref.uniforms;

      if (!this.state.model) {
        return;
      }

      var viewport = this.context.viewport;
      var _this$props = this.props,
          sizeScale = _this$props.sizeScale,
          coordinateSystem = _this$props.coordinateSystem,
          _instanced = _this$props._instanced;
      this.state.model.setUniforms(uniforms).setUniforms({
        sizeScale: sizeScale,
        composeModelMatrix: !_instanced || (0, _matrix.shouldComposeModelMatrix)(viewport, coordinateSystem),
        flatShading: !this.state.hasNormals
      }).draw();
    }
  }, {
    key: "isLoaded",
    get: function get() {
      var _this$state;

      return ((_this$state = this.state) === null || _this$state === void 0 ? void 0 : _this$state.model) && (0, _get2.default)((0, _getPrototypeOf2.default)(SimpleMeshLayer.prototype), "isLoaded", this);
    }
  }, {
    key: "getModel",
    value: function getModel(mesh) {
      var model = new _core2.Model(this.context.gl, _objectSpread(_objectSpread({}, this.getShaders()), {}, {
        id: this.props.id,
        geometry: getGeometry(mesh, this.props._useMeshColors),
        isInstanced: true
      }));
      var texture = this.props.texture;
      var emptyTexture = this.state.emptyTexture;
      model.setUniforms({
        sampler: texture || emptyTexture,
        hasTexture: Boolean(texture)
      });
      return model;
    }
  }, {
    key: "setTexture",
    value: function setTexture(texture) {
      var _this$state2 = this.state,
          emptyTexture = _this$state2.emptyTexture,
          model = _this$state2.model;

      if (model) {
        model.setUniforms({
          sampler: texture || emptyTexture,
          hasTexture: Boolean(texture)
        });
      }
    }
  }]);
  return SimpleMeshLayer;
}(_core.Layer);

exports.default = SimpleMeshLayer;
(0, _defineProperty2.default)(SimpleMeshLayer, "defaultProps", defaultProps);
(0, _defineProperty2.default)(SimpleMeshLayer, "layerName", 'SimpleMeshLayer');
//# sourceMappingURL=simple-mesh-layer.js.map