declare const _default: "#version 300 es\n\n// Uniforms\nuniform float opacity;\n\n// Varying\nin vec4 vColor;\n\nout vec4 fragmentColor;\n\n// MODULE_PBR contains all the varying definitions needed\n#ifndef MODULE_PBR\n  #if defined(HAS_UV) && defined(HAS_BASECOLORMAP)\n    in vec2 vTEXCOORD_0;\n    uniform sampler2D u_BaseColorSampler;\n  #endif\n#endif\n\nvoid main(void) {\n  #ifdef MODULE_PBR\n    fragmentColor = vColor * pbr_filterColor(vec4(0));\n    geometry.uv = pbr_vUV;\n  #else\n    #if defined(HAS_UV) && defined(HAS_BASECOLORMAP)\n      fragmentColor = vColor * texture2D(u_BaseColorSampler, vTEXCOORD_0);\n      geometry.uv = vTEXCOORD_0;\n    #else\n      fragmentColor = vColor;\n    #endif\n  #endif\n\n  fragmentColor.a *= opacity;\n  DECKGL_FILTER_COLOR(fragmentColor, geometry);\n}\n";
export default _default;
//# sourceMappingURL=scenegraph-layer-fragment.glsl.d.ts.map